/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.springframework.social.linkedin.api.Post;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupCountMixin
extends LinkedInObjectMixin {
    @JsonCreator
    GroupCountMixin(@JsonProperty(value="category") @JsonDeserialize(using=PostCategoryDeserializer.class) Post.PostCategory category, @JsonProperty(value="count") Integer count) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PostCategoryDeserializer
    extends JsonDeserializer<Post.PostCategory> {
        private PostCategoryDeserializer() {
        }

        public Post.PostCategory deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node;
            if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT) && (node = (JsonNode)jp.readValueAs(JsonNode.class)).has("code")) {
                return Post.PostCategory.valueOf(node.get("code").textValue().replace('-', '_').toUpperCase());
            }
            throw ctxt.mappingException("Expected JSON object");
        }
    }
}

