/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractTemplate {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");

    AbstractTemplate() {
    }

    protected URI expand(String url, Object[] variables, boolean encode) {
        Matcher matcher = NAMES_PATTERN.matcher(url);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        String separator = "";
        while (matcher.find()) {
            Object uriVariable;
            String replacement = Matcher.quoteReplacement((uriVariable = variables[i++]) != null ? (encode ? this.encode(uriVariable.toString()) : uriVariable.toString()) : "");
            String key = matcher.group();
            if (key.charAt(1) == '&' && replacement != null && replacement.length() > 0) {
                key = key.substring(2, key.length() - 1);
                matcher.appendReplacement(buffer, separator + key + '=' + replacement);
                separator = "&";
                continue;
            }
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        try {
            return new URI(buffer.toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Could not create URI from [" + buffer + "]: " + ex, ex);
        }
    }

    private String encode(String param) {
        byte[] source = param.getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);
        for (int i = 0; i < source.length; ++i) {
            int b = source[i];
            if (b < 0) {
                b += 256;
            }
            if (this.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        return bos.toString();
    }

    private boolean isAllowed(int c) {
        if (61 == c || 43 == c || 38 == c) {
            return false;
        }
        return this.isPchar(c) || 47 == c || 63 == c;
    }

    private boolean isPchar(int c) {
        return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
    }

    private boolean isUnreserved(int c) {
        return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
    }

    private boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isSubDelimiter(int c) {
        return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
    }
}

