/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.socialnetwork;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.personalorganizer.socialnetwork.SocialInformationEvent;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.provider.SocialEventProvider;
import org.silverpeas.core.util.DateUtil;

@Provider
public class SocialEvent
implements SocialEventProvider {
    @Inject
    private SilverpeasCalendar calendar;

    private SilverpeasCalendar getCalendar() {
        return this.calendar;
    }

    protected SocialEvent() {
    }

    public List<SocialInformation> getSocialInformationsList(String userId, String classification, Date begin, Date end) {
        String now = DateUtil.date2SQLDate((Date)new Date());
        List<JournalHeader> list = this.getCalendar().getNextEventsForUser(now, userId, classification, begin, end);
        ArrayList<SocialInformation> listEvent = new ArrayList<SocialInformation>(list.size());
        for (JournalHeader jh : list) {
            SocialInformationEvent event = new SocialInformationEvent(jh);
            listEvent.add((SocialInformation)event);
        }
        return listEvent;
    }

    public List<SocialInformation> getSocialInformationList(String userId, Date begin, Date end) {
        return this.getSocialInformationsList(userId, "", begin, end);
    }

    public List getSocialInformationListOfMyContacts(String myId, List<String> myContactsIds, Date begin, Date end) {
        String day = DateUtil.date2SQLDate((Date)new Date());
        return this.getCalendar().getNextEventsForMyContacts(day, myId, myContactsIds, begin, end);
    }

    public List getLastSocialInformationsListOfMyContacts(String myId, List<String> myContactsIds, Date begin, Date end) {
        String day = DateUtil.date2SQLDate((Date)new Date());
        return this.getCalendar().getLastEventsForMyContacts(day, myId, myContactsIds, begin, end);
    }

    public List getMyLastSocialInformationsList(String myId, Date begin, Date end) {
        String day = DateUtil.date2SQLDate((Date)new Date());
        return this.getCalendar().getMyLastEvents(day, myId, begin, end);
    }
}

