/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.util.FileManagerImpl;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.util.Locator;
import org.apache.jena.util.TypedStream;

public interface FileManager {
    public static final boolean logAllLookups = true;
    public static final String PATH_DELIMITER = ";";
    public static final String filePathSeparator = File.separator;

    public static FileManager getInternal() {
        return FileManagerImpl.get();
    }

    @Deprecated
    public static FileManager get() {
        return FileManager.getInternal();
    }

    @Deprecated
    public static void setGlobalFileManager(FileManager fm) {
        FileManagerImpl.setGlobalFileManager(fm);
    }

    @Deprecated
    public static FileManager create() {
        return new FileManagerImpl();
    }

    @Deprecated
    public static FileManager createStd() {
        return FileManagerImpl.makeStd();
    }

    @Deprecated
    public static FileManager create(LocationMapper locMap) {
        return new FileManagerImpl(locMap);
    }

    public FileManager clone();

    public void setLocationMapper(LocationMapper var1);

    public LocationMapper getLocationMapper();

    public Iterator<Locator> locators();

    public void addLocator(Locator var1);

    public void addLocatorFile();

    public void addLocatorFile(String var1);

    public void addLocatorClassLoader(ClassLoader var1);

    public void addLocatorURL();

    public void addLocatorZip(String var1);

    public void remove(Locator var1);

    @Deprecated
    public void resetCache();

    @Deprecated
    public void setModelCaching(boolean var1);

    @Deprecated
    public boolean isCachingModels();

    @Deprecated
    public Model getFromCache(String var1);

    @Deprecated
    public boolean hasCachedModel(String var1);

    @Deprecated
    public void addCacheModel(String var1, Model var2);

    @Deprecated
    public void removeCacheModel(String var1);

    @Deprecated
    default public Model loadModel(String filenameOrURI) {
        return this.loadModelInternal(filenameOrURI);
    }

    public Model loadModelInternal(String var1);

    @Deprecated
    public Model loadModel(String var1, String var2);

    @Deprecated
    public Model loadModel(String var1, String var2, String var3);

    default public Model readModel(Model model, String filenameOrURI) {
        return this.readModelInternal(model, filenameOrURI);
    }

    public Model readModelInternal(Model var1, String var2);

    @Deprecated
    public Model readModel(Model var1, String var2, String var3);

    @Deprecated
    public Model readModel(Model var1, String var2, String var3, String var4);

    public InputStream open(String var1);

    public String mapURI(String var1);

    @Deprecated
    public String readWholeFileAsUTF8(InputStream var1);

    @Deprecated
    public String readWholeFileAsUTF8(String var1);

    public InputStream openNoMap(String var1);

    public TypedStream openNoMapOrNull(String var1);
}

