/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.Calendar;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.commit.DefaultThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JcrLastModifiedConflictHandler
extends DefaultThreeWayConflictHandler {
    public JcrLastModifiedConflictHandler() {
        super(ThreeWayConflictHandler.Resolution.IGNORED);
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        if (JcrLastModifiedConflictHandler.isModifiedOrCreated(ours.getName()) && JcrLastModifiedConflictHandler.merge(parent, ours, theirs)) {
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        if (JcrLastModifiedConflictHandler.isModifiedOrCreated(ours.getName()) && JcrLastModifiedConflictHandler.merge(parent, ours, theirs)) {
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static boolean merge(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        Calendar t;
        Calendar o = ISO8601.parse((String)((String)ours.getValue(Type.DATE)));
        Calendar value = JcrLastModifiedConflictHandler.pick(o, t = ISO8601.parse((String)((String)theirs.getValue(Type.DATE))), "jcr:created".equals(ours.getName()));
        if (value != null) {
            parent.setProperty(ours.getName(), (Object)value);
            return true;
        }
        return false;
    }

    @Nullable
    private static Calendar pick(@Nullable Calendar ours, @Nullable Calendar theirs, boolean jcrCreated) {
        if (ours == null) {
            return theirs;
        }
        if (theirs == null) {
            return ours;
        }
        if (ours.before(theirs)) {
            return jcrCreated ? ours : theirs;
        }
        return jcrCreated ? theirs : ours;
    }

    private static boolean isModifiedOrCreated(@NotNull String name) {
        return "jcr:lastModified".equals(name) || "jcr:created".equals(name);
    }
}

