/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.socialnetwork;

import java.util.Objects;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.socialnetwork.model.AbstractSocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;

public class SocialInformationComment
extends AbstractSocialInformation {
    private final Comment comment;

    public SocialInformationComment(Comment comment) {
        super(comment.getIdentifier().toReference());
        this.comment = comment;
        this.setAuthor(comment.getCreatorId());
        if (comment.getLastUpdateDate().equals(comment.getCreationDate())) {
            this.setDate(comment.getCreationDate());
            this.setUpdated(false);
        } else {
            this.setDate(comment.getLastUpdateDate());
            this.setUpdated(true);
        }
        String instanceId = comment.getComponentInstanceId();
        SocialInformationType type = SocialInformationType.COMMENTPUBLICATION;
        if (instanceId.startsWith("blog")) {
            type = SocialInformationType.COMMENTPOST;
        } else if (instanceId.startsWith("quickinfo")) {
            type = SocialInformationType.COMMENTNEWS;
        } else if (instanceId.startsWith("gallery")) {
            type = SocialInformationType.COMMENTMEDIA;
        }
        this.setType(type.toString());
        this.setDescription(comment.getMessage());
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SocialInformationComment other = (SocialInformationComment)((Object)obj);
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.author, other.author)) {
            return false;
        }
        if (!Objects.equals(this.date, other.date)) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (this.getTitle() == null ? other.getTitle() != null : !this.getTitle().equals(other.getTitle())) {
            return false;
        }
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        return this.getDescription() == null ? other.getDescription() == null : this.getDescription().equals(other.getDescription());
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 43 * hash + (this.author != null ? this.author.hashCode() : 0);
        hash = 43 * hash + (this.date != null ? this.date.hashCode() : 0);
        hash = 43 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public Comment getComment() {
        return this.comment;
    }
}

