/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.attachment;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.importexport.attachment.AttachmentPK;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public final class AttachmentDetail
implements Serializable {
    private static final long serialVersionUID = 5441809463555598057L;
    private AttachmentPK pk = null;
    private String filename = null;
    @XmlAttribute(name="path")
    private String physicalName = null;
    private String type = null;
    private Date creationDate;
    private long size;
    private String context = null;
    private String author = null;
    @XmlElement(name="name")
    private String title = null;
    @XmlElement(name="description")
    private String description = null;
    private String instanceId = null;
    public static final String IMPORT_UPDATE_RULE_ADD = "add";
    public static final String IMPORT_UPDATE_RULE_REPLACE = "replace";
    @XmlAttribute(name="updateRule")
    private String importUpdateRule = "add";
    @XmlAttribute
    private boolean removeAfterImport = false;
    private String originalPath;
    private String xmlForm = null;
    @XmlElement(name="xmlModel")
    private XMLModelContentType xmlModelContentType = null;
    private String mailContentID = null;

    public AttachmentDetail() {
    }

    public AttachmentDetail(SimpleDocument document, String physicalName) {
        this.pk = new AttachmentPK(document.getId(), document.getInstanceId());
        this.physicalName = physicalName;
        this.title = document.getTitle();
        this.description = document.getDescription();
        this.type = document.getContentType();
        this.size = document.getSize();
        this.setContext(document.getDocumentType().toString());
        this.creationDate = document.getCreationDate();
    }

    public AttachmentPK getPK() {
        return this.pk;
    }

    public void setPK(AttachmentPK pk) {
        this.pk = pk;
        if (pk != null) {
            this.instanceId = pk.getInstanceId();
        }
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public String getLogicalName() {
        if (this.filename != null) {
            return this.filename;
        }
        return FileUtil.getFilename((String)this.getPhysicalName());
    }

    public void setLogicalName(String logicalName) {
        this.filename = logicalName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setContext(String context) {
        this.context = StringUtil.isDefined((String)context) ? context : null;
    }

    public String getContext() {
        return this.context;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String title2) {
        this.title = title2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String info) {
        this.description = info;
    }

    public String getDescription() {
        return this.description;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    protected String getLanguage(String language) {
        if (language != null && ("fr".equalsIgnoreCase(language) || "".equals(language.trim()))) {
            return null;
        }
        return language;
    }

    public String getAttachmentPath() {
        if (this.isPhysicalPathAbsolute()) {
            return this.physicalName.replace('/', File.separatorChar);
        }
        Object directory = FileRepositoryManager.getAbsolutePath((String)this.getInstanceId(), (String[])FileRepositoryManager.getAttachmentContext((String)this.getContext()));
        if (!((String)directory).endsWith(File.separator)) {
            directory = (String)directory + File.separatorChar;
        }
        directory = ((String)directory).replace('/', File.separatorChar);
        return (String)directory + this.getPhysicalName();
    }

    private boolean isPhysicalPathAbsolute() {
        String filePath = FilenameUtils.separatorsToSystem((String)this.physicalName);
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public String getImportUpdateRule() {
        return this.importUpdateRule;
    }

    public String getXmlForm() {
        return this.xmlForm;
    }

    public void setXmlForm(String xmlForm) {
        this.xmlForm = xmlForm;
    }

    public XMLModelContentType getXMLModelContentType() {
        return this.xmlModelContentType;
    }

    public boolean isRemoveAfterImport() {
        return this.removeAfterImport;
    }

    public void setRemoveAfterImport(boolean removeAfterImport) {
        this.removeAfterImport = removeAfterImport;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public String getMailContentID() {
        return this.mailContentID;
    }

    public void setMailContentID(String mailContentID) {
        this.mailContentID = mailContentID;
    }
}

