/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.service;

import java.io.File;
import java.lang.annotation.Annotation;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.viewer.service.PreviewService;
import org.silverpeas.core.viewer.service.ViewService;

@Provider
public class ViewerProvider {
    private ViewerProvider() {
    }

    public static PreviewService getPreviewService() {
        return (PreviewService)ServiceProvider.getService(PreviewService.class, (Annotation[])new Annotation[0]);
    }

    public static boolean isPreviewable(File file) {
        return ViewerProvider.getPreviewService().isPreviewable(file);
    }

    public static boolean isPreviewable(String path) {
        return ViewerProvider.getPreviewService().isPreviewable(new File(path));
    }

    public static boolean isViewable(File file) {
        return ViewerProvider.getViewService().isViewable(file);
    }

    public static boolean isViewable(String path) {
        return ViewerProvider.getViewService().isViewable(new File(path));
    }

    public static ViewService getViewService() {
        return (ViewService)ServiceProvider.getService(ViewService.class, (Annotation[])new Annotation[0]);
    }
}

