/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.Debug;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcSearchResultReference;
import java.io.IOException;
import java.net.MalformedURLException;

public class LDAPSearchResultReference
extends LDAPMessage {
    private String[] srefs;
    private static Object nameLock = new Object();
    private static int refNum = 0;
    private String name;

    public LDAPSearchResultReference() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPSearchResultReference(RfcLDAPMessage message) {
        super(message);
        Object object = nameLock;
        synchronized (object) {
            this.name = "SearchResultReference(" + ++refNum + "): ";
        }
        Debug.trace("Referrals", this.name + "Created");
    }

    public LDAPSearchResultReference(String[] referals) throws MalformedURLException {
        super(new RfcLDAPMessage(new RfcSearchResultReference(referals)));
    }

    public String[] getReferrals() {
        Debug.trace("Messages", this.name + "Enter getReferrals");
        ASN1Object[] references = ((RfcSearchResultReference)this.message.getResponse()).toArray();
        this.srefs = new String[references.length];
        for (int i = 0; i < references.length; ++i) {
            this.srefs[i] = ((ASN1OctetString)references[i]).stringValue();
            Debug.trace("Referrals", this.name + "\t" + this.srefs[i]);
        }
        return this.srefs;
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPSearchResultReference)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPSearchResultReference object");
        }
        LDAPSearchResultReference tmp = (LDAPSearchResultReference)readObject;
        String[] referals = tmp.getReferrals();
        tmp = null;
        this.message = new RfcLDAPMessage(new RfcSearchResultReference(referals));
        readObject = null;
    }
}

