/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NIODataDescriptorPacket;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class SessionAtts
implements SQLnetDef {
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    private int sdu;
    private int tdu;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled = false;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect = false;
    public boolean anoActive;
    protected boolean isLargeSDU = false;
    protected int negotiatedSDU = -1;
    protected boolean redirecting = false;
    SocketChannel socketChannel;
    public NIONSDataChannel dataChannel;
    NIOMarkerPacket markerPacket;
    NIODataDescriptorPacket ddPacket;
    public ByteBuffer buffer = null;
    ByteBuffer payloadBuffer = null;
    ByteBuffer headerBuffer = null;
    public ByteBuffer payloadDataBuffer = null;
    boolean useNativeBuffers = false;
    String traceId;

    public SessionAtts(NSProtocol nSProtocol, int n2, int n3, boolean bl, boolean bl2) {
        this.sdu = n2;
        this.tdu = n3;
        this.ns = nSProtocol;
        this.anoActive = false;
        this.connected = false;
        if (bl) {
            this.dataChannel = new NIONSDataChannel(this);
            this.markerPacket = new NIOMarkerPacket(this);
            this.ddPacket = new NIODataDescriptorPacket(this);
            this.useNativeBuffers = bl2;
        }
    }

    protected void initializeBuffer(int n2) {
        this.buffer = this.useNativeBuffers ? ByteBuffer.allocateDirect(n2) : ByteBuffer.allocate(n2);
        this.buffer.limit(8);
        this.headerBuffer = this.buffer.slice();
        this.buffer.clear();
        this.buffer.position(8);
        this.payloadBuffer = this.buffer.slice();
        this.buffer.clear();
        this.buffer.position(10);
        this.payloadDataBuffer = this.buffer.slice();
    }

    public void setSDU(int n2) {
        this.sdu = n2 <= 0 ? 8192 : (n2 > 0x200000 ? 0x200000 : (n2 < 512 ? 512 : n2));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int n2) {
        this.tdu = n2 <= 0 ? 0x200000 : (n2 > 0x200000 ? 0x200000 : (n2 < 255 ? 255 : n2));
    }

    public int getTDU() {
        return this.tdu;
    }

    void setNegotiatedSDUAndTDU(int n2, int n3) {
        this.setTDU(n3);
        if (n3 < n2) {
            this.setSDU(n3);
        } else {
            this.setSDU(n2);
        }
        this.negotiatedSDU = this.sdu;
        this.initializeBuffer(this.getSDU());
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    void renegotiateSSLSession() throws IOException {
        ((TcpsNTAdapter)this.nt).renegotiateSession();
        this.ntInputStream = this.nt.getInputStream();
        this.ntOutputStream = this.nt.getOutputStream();
    }

    public String toString() {
        return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
    }

    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        if (netInputStream == null || netOutputStream == null) {
            throw new NetException(300);
        }
        this.nsInputStream = netInputStream;
        this.nsOutputStream = netOutputStream;
        this.anoActive = true;
    }

    public void turnEncryptionOn(NIONSDataChannel nIONSDataChannel) throws NetException {
        if (nIONSDataChannel == null) {
            throw new NetException(300);
        }
        this.dataChannel = nIONSDataChannel;
        this.anoActive = true;
    }

    public int getANOFlags() {
        int n2 = 1;
        if (this.ano != null) {
            n2 = this.ano.getNAFlags();
        }
        return n2;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public void setNegotiatedOptions(int n2) {
        this.negotiatedOptions = n2;
    }

    public int getNegotiatedOptions() {
        return this.negotiatedOptions;
    }

    public ConnOption getcOption() {
        return this.cOption;
    }
}

