/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;

public abstract class OracleXADataSource
extends OracleConnectionPoolDataSource
implements XADataSource {
    protected boolean useNativeXA = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    public OracleXADataSource() throws SQLException {
        this.dataSourceName = "OracleXADataSource";
    }

    @Override
    public abstract XAConnection getXAConnection() throws SQLException;

    @Override
    public abstract XAConnection getXAConnection(String var1, String var2) throws SQLException;

    public abstract XAConnection getXAConnection(Properties var1) throws SQLException;

    @Override
    public synchronized void setURL(String string) {
        super.setURL(string);
        if (string != null) {
            if (string.startsWith("jdbc:oracle:thin")) {
                this.useNativeXA = true;
            } else if (string.startsWith("jdbc:oracle:oci") || string.startsWith("jdbc:oracle:oci8")) {
                this.useNativeXA = false;
            }
        }
    }

    public synchronized void setNativeXA(boolean bl) {
        this.useNativeXA = bl;
    }

    public synchronized boolean getNativeXA() {
        return this.useNativeXA;
    }

    @Override
    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        super.copy(oracleDataSource);
        ((OracleXADataSource)oracleDataSource).useNativeXA = this.useNativeXA;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

