/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model.beans;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.components.mailinglist.service.model.beans.ExternalUser;
import org.silverpeas.components.mailinglist.service.model.beans.IdentifiableObject;
import org.silverpeas.components.mailinglist.service.model.beans.InternalGroupSubscriber;
import org.silverpeas.components.mailinglist.service.model.beans.InternalSubscriber;
import org.silverpeas.components.mailinglist.service.model.beans.InternalUser;
import org.silverpeas.components.mailinglist.service.model.beans.InternalUserSubscriber;
import org.silverpeas.kernel.annotation.NonNull;

@Entity
@Table(name="sc_mailinglist_list")
@NamedQueries(value={@NamedQuery(name="mailinglist.findByComponentId", query="select m from MailingList m where m.componentId = :componentId"), @NamedQuery(name="mailinglist.findAll", query="select m from MailingList m")})
public class MailingList
extends IdentifiableObject {
    private static final long serialVersionUID = 3983404426767796807L;
    private String componentId;
    @Transient
    private String name;
    @Transient
    private String subscribedAddress;
    @Transient
    private String description;
    @Transient
    private boolean open;
    @Transient
    private boolean moderated;
    @Transient
    private boolean notify;
    @Transient
    private boolean supportRSS;
    @Transient
    private transient Set<InternalUser> moderators = new HashSet<InternalUser>();
    @Transient
    private transient Set<InternalUser> readers = new HashSet<InternalUser>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="listId", nullable=false)
    private Set<ExternalUser> externalSubscribers = new HashSet<ExternalUser>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="mailingListId", nullable=false)
    private Set<InternalSubscriber> internalSubscribers = new HashSet<InternalSubscriber>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubscribedAddress() {
        return this.subscribedAddress;
    }

    public void setSubscribedAddress(String subscribedAddress) {
        this.subscribedAddress = subscribedAddress;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean publiclyVisible) {
        this.open = publiclyVisible;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    public Set<InternalUser> getModerators() {
        return this.moderators;
    }

    public void setModerators(Set<InternalUser> moderators) {
        this.moderators = moderators;
    }

    public Set<InternalUser> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<InternalUser> readers) {
        this.readers = readers;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public Set<ExternalUser> getExternalSubscribers() {
        return this.externalSubscribers;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public void removeExternalSubscriber(ExternalUser user) {
        this.externalSubscribers.remove(user);
    }

    public void addExternalSubscriber(ExternalUser user) {
        this.externalSubscribers.add(user);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSupportRSS() {
        return this.supportRSS;
    }

    public void setSupportRSS(boolean supportRSS) {
        this.supportRSS = supportRSS;
    }

    public boolean isEmailAuthorized(String email) {
        for (ExternalUser externalUser : this.externalSubscribers) {
            if (externalUser.getEmail() == null || !externalUser.getEmail().equalsIgnoreCase(email)) continue;
            return true;
        }
        for (InternalUser internalUser : this.readers) {
            if (internalUser.getEmail() == null || !internalUser.getEmail().equalsIgnoreCase(email)) continue;
            return true;
        }
        for (InternalUser internalUser : this.moderators) {
            if (internalUser.getEmail() == null || !internalUser.getEmail().equalsIgnoreCase(email)) continue;
            return true;
        }
        return false;
    }

    public Set<InternalGroupSubscriber> getGroupSubscribers() {
        return new InternalSubscriberSet<InternalGroupSubscriber>(InternalGroupSubscriber.class);
    }

    public Set<InternalUserSubscriber> getInternalSubscribers() {
        return new InternalSubscriberSet<InternalUserSubscriber>(InternalUserSubscriber.class);
    }

    private class InternalSubscriberSet<T extends InternalSubscriber>
    implements Set<T> {
        private final Class<T> subscriberType;

        InternalSubscriberSet(Class<T> typeOfT) {
            this.subscriberType = typeOfT;
        }

        private Stream<T> filter() {
            return MailingList.this.internalSubscribers.stream().filter(s -> s.getClass().isAssignableFrom(this.subscriberType));
        }

        @Override
        public int size() {
            return (int)this.filter().count();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return MailingList.this.internalSubscribers.contains(o);
        }

        @Override
        @NonNull
        public Iterator<T> iterator() {
            return this.filter().collect(Collectors.toSet()).iterator();
        }

        @Override
        @NonNull
        public Object[] toArray() {
            return this.filter().distinct().toArray();
        }

        @Override
        @NonNull
        public <T1> T1[] toArray(@NonNull T1[] a) {
            return this.filter().collect(Collectors.toSet()).toArray(a);
        }

        @Override
        public boolean add(T t) {
            return MailingList.this.internalSubscribers.add((InternalSubscriber)t);
        }

        @Override
        public boolean remove(Object o) {
            return MailingList.this.internalSubscribers.remove(o);
        }

        @Override
        public boolean containsAll(@NonNull Collection<?> c) {
            return MailingList.this.internalSubscribers.containsAll(c);
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends T> c) {
            return MailingList.this.internalSubscribers.addAll(c);
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> c) {
            return MailingList.this.internalSubscribers.retainAll(c);
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> c) {
            return MailingList.this.internalSubscribers.removeAll(c);
        }

        @Override
        public void clear() {
            Set subscribers = this.filter().collect(Collectors.toSet());
            MailingList.this.internalSubscribers.removeAll(subscribers);
        }
    }
}

