/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.util.concurrent;

public class Semaphore {
    private int maxConcurrentUsers;
    private int currentUsers;

    public Semaphore(int maxConcurrentUsers) {
        if (maxConcurrentUsers < 0) {
            throw new IllegalArgumentException("Semaphore <init> - maxConcurrentUsers has to be 0 or greater");
        }
        this.maxConcurrentUsers = maxConcurrentUsers;
        this.currentUsers = 0;
    }

    public int getMaxConcurrentUsers() {
        return this.maxConcurrentUsers;
    }

    public int getCurrentUsers() {
        return this.currentUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sWait() throws InterruptedException {
        if (this.maxConcurrentUsers > 0) {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                ++this.currentUsers;
                if (this.currentUsers > this.maxConcurrentUsers) {
                    this.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sSignal() {
        if (this.maxConcurrentUsers > 0) {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                if (this.currentUsers > 0) {
                    --this.currentUsers;
                }
                this.notify();
            }
        }
    }
}

