/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.silverstatistics.volume.model.SilverStatisticsConfigException;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsConfig;
import org.silverpeas.core.silverstatistics.volume.service.DirectoryVolumeService;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatistics;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsProvider;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsSender;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class SilverStatisticsManager
implements Initialization {
    private static final String STAT_SIZE_JOB_NAME = "SilverStatisticsSize";
    private static final String STAT_CUMULI_JOB_NAME = "SilverStatisticsCumul";
    private static final String STAT_VOLUME_JOB_NAME = "SilverStatisticsVolume";
    private List<String> directoryToScan = null;
    private StatisticsConfig statsConfig = null;

    private SilverStatisticsManager() {
    }

    public void init() {
        this.directoryToScan = new ArrayList<String>();
        try {
            this.statsConfig = new StatisticsConfig();
            this.statsConfig.init();
            if (!this.statsConfig.isValidConfigFile()) {
                SilverLogger.getLogger((Object)this).error("Statistics configuration is not valid", new Object[0]);
            }
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.silverstatistics.SilverStatistics");
            String sizeStatCron = settings.getString("scheduledGetStatSizeTimeStamp");
            String volumeStatCron = settings.getString("scheduledGetStatVolumeTimeStamp");
            String consolidationStatCron = settings.getString("scheduledCumulStatTimeStamp");
            this.initSchedulerStatistics(sizeStatCron, STAT_SIZE_JOB_NAME, this::doGetStatSize);
            this.initSchedulerStatistics(volumeStatCron, STAT_VOLUME_JOB_NAME, this::doGetStatVolume);
            this.initSchedulerStatistics(consolidationStatCron, STAT_CUMULI_JOB_NAME, this::doConsolidationStat);
            this.initDirectoryToScan(settings);
        }
        catch (SilverStatisticsConfigException e) {
            SilverLogger.getLogger((Object)this).error("Initialization of statistics configuration failed", (Throwable)((Object)e));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
        }
    }

    public void release() throws SchedulerException {
        Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
        scheduler.unscheduleJob(STAT_SIZE_JOB_NAME);
        scheduler.unscheduleJob(STAT_VOLUME_JOB_NAME);
        scheduler.unscheduleJob(STAT_CUMULI_JOB_NAME);
    }

    public static SilverStatisticsManager getInstance() {
        return (SilverStatisticsManager)ServiceProvider.getService(SilverStatisticsManager.class, (Annotation[])new Annotation[0]);
    }

    private void initSchedulerStatistics(String aCronString, String jobName, Consumer<Date> jobOperation) throws SilverpeasException {
        try {
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(jobName);
            JobTrigger trigger = JobTrigger.triggerAt((String)aCronString);
            Job job = this.createJobWith(jobName, jobOperation);
            scheduler.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new SilverpeasException((Throwable)e);
        }
    }

    private void doGetStatVolume(Date currentDate) {
        try {
            this.getSilverStatistics().makeVolumeAlimentationForAllComponents();
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error("error during volume statistic computing started at {0}", new Object[]{currentDate}, (Throwable)ex);
        }
    }

    private void doGetStatSize(Date currentDate) {
        block3: {
            try {
                for (String aDirectoryToScan : this.directoryToScan) {
                    DirectoryVolumeService service = new DirectoryVolumeService(new File(aDirectoryToScan));
                    this.addStatSize(currentDate, aDirectoryToScan, service.getTotalSize());
                }
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error("error during size statistic computing started at {0}", new Object[]{currentDate}, (Throwable)ex);
                if (!(ex instanceof InterruptedException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void doConsolidationStat(Date currentDate) {
        try {
            this.getSilverStatistics().makeStatAllCumul();
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error("error during statistic consolidation computing started at {0}", new Object[]{currentDate}, (Throwable)ex);
        }
    }

    private void initDirectoryToScan(SettingBundle resource) {
        try {
            int i = 0;
            String directoryPath = resource.getString("SilverPeasDataPath" + i, null);
            while (directoryPath != null) {
                File dir = new File(directoryPath);
                if (!dir.isDirectory()) {
                    throw new SilverpeasException("SilverStatistics initDirectoryToScan " + directoryPath, new String[0]);
                }
                this.directoryToScan.add(directoryPath);
                directoryPath = resource.getString("SilverPeasDataPath" + ++i, null);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Statistics directory scanning in error", (Throwable)e);
        }
    }

    public void addStatVolume(String userId, long volume, Date dateAccess, String peasType, String spaceId, String componentId) {
        if (this.statsConfig.isRun(StatType.Volume)) {
            StringBuilder stat = this.buildStatisticData(userId, dateAccess, peasType, spaceId, componentId);
            stat.append(volume);
            this.sendStatistic(StatType.Volume, stat);
        }
    }

    private StringBuilder buildStatisticData(String userId, Date dateAccess, String peasType, String spaceId, String componentId) {
        StringBuilder stat = new StringBuilder();
        stat.append(DateUtil.formatAsISO8601Day((Date)dateAccess));
        stat.append("&&&");
        stat.append(userId);
        stat.append("&&&");
        stat.append(peasType);
        stat.append("&&&");
        stat.append(spaceId);
        stat.append("&&&");
        stat.append(componentId);
        stat.append("&&&");
        return stat;
    }

    private void sendStatistic(StatType type, CharSequence stat) {
        if (this.isAsynchronStats(type)) {
            SilverStatisticsSender mySilverStatisticsSender = SilverStatisticsSender.get();
            try {
                mySilverStatisticsSender.send(type, stat.toString());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        } else {
            this.getSilverStatistics().putStats(type, stat.toString());
        }
    }

    public void addStatAccess(String userId, Date dateAccess, String peasType, String spaceId, String componentId) {
        if (this.statsConfig.isRun(StatType.Access)) {
            StringBuilder stat = this.buildStatisticData(userId, dateAccess, peasType, spaceId, componentId);
            stat.append("1");
            this.sendStatistic(StatType.Access, stat);
        }
    }

    public void addStatConnection(String userId, Date dateConnection, int count, long duration) {
        if (this.statsConfig.isRun(StatType.Connexion)) {
            StringBuilder stat = new StringBuilder();
            stat.append(DateUtil.formatAsISO8601Day((Date)dateConnection));
            stat.append("&&&");
            stat.append(userId);
            stat.append("&&&");
            stat.append(Long.toString(count));
            stat.append("&&&");
            stat.append(duration);
            this.sendStatistic(StatType.Connexion, stat);
        }
    }

    public void addStatSize(Date date, String dirName, long dirSize) {
        if (this.statsConfig.isRun(StatType.Size)) {
            StringBuilder stat = new StringBuilder();
            stat.append(DateUtil.formatAsISO8601Day((Date)date));
            stat.append("&&&");
            stat.append(dirName);
            stat.append("&&&");
            stat.append(dirSize);
            this.sendStatistic(StatType.Size, stat);
        }
    }

    private boolean isAsynchronStats(StatType typeStats) {
        try {
            if (this.statsConfig == null) {
                this.statsConfig = new StatisticsConfig();
                this.statsConfig.init();
            }
            if (this.statsConfig.isValidConfigFile()) {
                return this.statsConfig.isAsynchron(typeStats);
            }
        }
        catch (SilverStatisticsConfigException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
        return false;
    }

    private SilverStatistics getSilverStatistics() {
        return SilverStatisticsProvider.getSilverStatistics();
    }

    private Job createJobWith(String jobName, final Consumer<Date> jobOperation) throws SchedulerException {
        try {
            return new Job(jobName){

                public void execute(JobExecutionContext context) {
                    Date date = context.getFireTime();
                    jobOperation.accept(date);
                }
            };
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
            throw new SchedulerException(ex.getMessage());
        }
    }
}

