/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.office.ExternalOfficeConnectionManager;
import org.jodconverter.local.office.OfficeConnectionEvent;
import org.jodconverter.local.office.OfficeConnectionEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalOfficeManagerPoolEntry
extends AbstractOfficeManagerPoolEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalOfficeManagerPoolEntry.class);
    private final boolean connectOnStart;
    private final int maxTasksPerConnection;
    private final ExternalOfficeConnectionManager connectionManager;
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private final AtomicBoolean disconnectExpected = new AtomicBoolean(false);

    ExternalOfficeManagerPoolEntry(boolean connectOnStart, int maxTasksPerConnection, long taskExecutionTimeout, final ExternalOfficeConnectionManager connectionManager) {
        super(taskExecutionTimeout);
        this.connectOnStart = connectOnStart;
        this.maxTasksPerConnection = maxTasksPerConnection;
        this.connectionManager = connectionManager;
        OfficeConnectionEventListener connectionEventListener = new OfficeConnectionEventListener(){

            @Override
            public void connected(OfficeConnectionEvent event) {
                ExternalOfficeManagerPoolEntry.this.taskCount.set(0);
                ExternalOfficeManagerPoolEntry.this.setAvailable(true);
            }

            @Override
            public void disconnected(OfficeConnectionEvent event) {
                ExternalOfficeManagerPoolEntry.this.setAvailable(false);
                if (!ExternalOfficeManagerPoolEntry.this.disconnectExpected.compareAndSet(true, false)) {
                    LOGGER.warn("Connection lost unexpectedly; attempting reconnect");
                    ExternalOfficeManagerPoolEntry.this.cancelTask();
                    connectionManager.reconnect();
                }
            }
        };
        connectionManager.getConnection().addConnectionEventListener(connectionEventListener);
    }

    protected void doExecute(@NonNull OfficeTask task) throws OfficeException {
        this.connectionManager.ensureConnected();
        task.execute((OfficeContext)this.connectionManager.getConnection());
        int count = this.taskCount.incrementAndGet();
        if (count == this.maxTasksPerConnection) {
            LOGGER.info("Reached limit of {} maximum tasks per connection; reconnecting...", (Object)this.maxTasksPerConnection);
            this.reconnect();
        }
    }

    protected void handleExecuteTimeoutException(@NonNull TimeoutException timeoutEx) {
        this.reconnect();
    }

    public boolean isRunning() {
        return super.isRunning() && this.connectionManager.getConnection().isConnected();
    }

    public void doStart() throws OfficeException {
        if (this.connectOnStart) {
            this.connectionManager.connect();
        }
    }

    public void doStop() throws OfficeException {
        this.setAvailable(false);
        this.disconnectExpected.set(true);
        this.connectionManager.disconnect();
    }

    private void reconnect() {
        this.setAvailable(false);
        this.disconnectExpected.set(true);
        this.connectionManager.reconnect();
    }
}

