/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.util.logging.Error;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Interceptor
@Error
@Priority(value=2000)
public class ErrorAnnotationProcessor {
    protected static final String SYSTEM_DEFAULT_PATTERN = "[SYSTEM] Error in {0}#{1}:";
    protected static final String USER_DEFAULT_PATTERN = "[{0} ({1})] Error in {2}#{3}:";
    protected static final String SYSTEM_CUSTOM_PATTERN = "[SYSTEM] {0}";
    protected static final String USER_CUSTOM_PATTERN = "[{0} ({1})] {2}";

    @AroundInvoke
    public Object produceLogRecords(InvocationContext context) throws Exception {
        try {
            return context.proceed();
        }
        catch (Exception e) {
            SilverLogger logger = SilverLogger.getLogger((Object)context.getTarget());
            ErrorProperties errorProps = this.getErrorProperties(context).withException(e);
            if (StringUtil.isDefined((String)errorProps.getMessage())) {
                this.logCustomMessage(logger, errorProps, context);
            } else {
                this.logDefaultMessage(logger, errorProps, context);
            }
            if (errorProps.isRethrown()) {
                throw e;
            }
            return null;
        }
    }

    private void logCustomMessage(SilverLogger logger, ErrorProperties errorProps, InvocationContext context) {
        UserDetail currentUser = UserDetail.getCurrentRequester();
        String message = this.computeCustomMessage(errorProps.getMessage(), errorProps.getException(), context);
        if (currentUser == null) {
            logger.error(SYSTEM_CUSTOM_PATTERN, new Object[]{message});
        } else {
            logger.error(USER_CUSTOM_PATTERN, new Object[]{currentUser.getDisplayedName(), currentUser.getId(), message});
        }
    }

    private void logDefaultMessage(SilverLogger logger, ErrorProperties errorProps, InvocationContext context) {
        UserDetail currentUser = UserDetail.getCurrentRequester();
        String className = context.getMethod().getDeclaringClass().getSimpleName();
        String message = this.computeDefaultMessage(context);
        if (currentUser == null) {
            logger.error(SYSTEM_DEFAULT_PATTERN, new Object[]{className, message}, (Throwable)errorProps.getException());
        } else {
            logger.error(USER_DEFAULT_PATTERN, new Object[]{currentUser.getDisplayedName(), currentUser.getId(), className, message}, (Throwable)errorProps.getException());
        }
    }

    private ErrorProperties getErrorProperties(InvocationContext context) {
        Method method = context.getMethod();
        Error error = method.getAnnotation(Error.class);
        if (error == null) {
            error = method.getDeclaringClass().getAnnotation(Error.class);
        }
        Objects.requireNonNull(error);
        return new ErrorProperties(error);
    }

    private String computeDefaultMessage(InvocationContext context) {
        Object[] parameters = context.getParameters();
        String p = Stream.of(parameters).map(Object::toString).collect(Collectors.joining(", "));
        return context.getMethod().getName() + "(" + p + ")";
    }

    private String computeCustomMessage(String messagePattern, Exception e, InvocationContext context) {
        String pattern = messagePattern.replace("{m}", e.getMessage());
        if (messagePattern.contains("{e}")) {
            StringWriter stacktrace = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)stacktrace, true));
            pattern = pattern.replace("{e}", stacktrace.toString());
        }
        Object[] parameters = (String[])Stream.of(context.getParameters()).map(Object::toString).toArray(String[]::new);
        return MessageFormat.format(pattern, parameters);
    }

    private static class ErrorProperties {
        private final String message;
        private final boolean rethrown;
        private Exception exception;

        public ErrorProperties(Error error) {
            this.message = error.message().trim();
            this.rethrown = error.rethrown();
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isRethrown() {
            return this.rethrown;
        }

        public Exception getException() {
            return this.exception;
        }

        ErrorProperties withException(Exception e) {
            this.exception = e;
            return this;
        }
    }
}

