/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.constant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public enum SubscriptionMethod {
    UNKNOWN,
    SELF_CREATION,
    FORCED;

    private static final Collection<SubscriptionMethod> VALID_VALUES;

    public boolean isValid() {
        return !this.equals((Object)UNKNOWN);
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    @JsonCreator
    public static SubscriptionMethod from(String name) {
        if (name != null) {
            for (SubscriptionMethod subscriptionMethod : SubscriptionMethod.values()) {
                if (!name.equals(subscriptionMethod.name())) continue;
                return subscriptionMethod;
            }
        }
        return UNKNOWN;
    }

    public static Collection<SubscriptionMethod> getValidValues() {
        return VALID_VALUES;
    }

    static {
        VALID_VALUES = new ArrayList<SubscriptionMethod>(Arrays.asList(SubscriptionMethod.values()));
        VALID_VALUES.remove((Object)UNKNOWN);
    }
}

