/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.socialnetwork.SocialNetworkException;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;
import org.silverpeas.core.socialnetwork.provider.SocialEventProvider;
import org.silverpeas.core.socialnetwork.provider.SocialInformationProviderSwitcher;
import org.silverpeas.core.socialnetwork.provider.SocialMediaCommentProvider;
import org.silverpeas.core.socialnetwork.provider.SocialMediaProvider;
import org.silverpeas.core.socialnetwork.provider.SocialNewsCommentProvider;
import org.silverpeas.core.socialnetwork.provider.SocialPublicationCommentProvider;
import org.silverpeas.core.socialnetwork.provider.SocialPublicationProvider;
import org.silverpeas.core.socialnetwork.provider.SocialRelationShipProvider;
import org.silverpeas.core.socialnetwork.provider.SocialStatusProvider;
import org.silverpeas.kernel.util.Pair;

@Provider
public class DefaultSocialInformationProviderSwitcher
implements SocialInformationProviderSwitcher {
    private Map<SocialInformationType, Pair<SocialInfoListSupplier, SocialInfoListSupplier>> providers = new EnumMap<SocialInformationType, Pair<SocialInfoListSupplier, SocialInfoListSupplier>>(SocialInformationType.class);
    private List<SocialInformationType> exclusion = Arrays.asList(SocialInformationType.ALL, SocialInformationType.EVENT, SocialInformationType.COMMENT, SocialInformationType.COMMENTPUBLICATION, SocialInformationType.COMMENTNEWS, SocialInformationType.COMMENTMEDIA);
    private static final Pair<SocialInfoListSupplier, SocialInfoListSupplier> NOTHING = Pair.of(c -> Collections.emptyList(), c -> Collections.emptyList());

    @PostConstruct
    private void initSocialInfoProviders() {
        this.providers.put(SocialInformationType.EVENT, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> this.getSocialEventsProvider().getSocialInformationsList(c.getUserId(), c.getClassification(), c.getBeginDate(), c.getEndDate()), c -> this.getSocialEventsProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate())));
        this.providers.put(SocialInformationType.MEDIA, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> {
            List<SocialInformation> results = this.getSocialMediaProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate());
            results.addAll(this.getSocialInformationsList(SocialInformationType.COMMENTMEDIA, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }, c -> {
            List<SocialInformation> results = this.getSocialMediaProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate());
            results.addAll(this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTMEDIA, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }));
        this.providers.put(SocialInformationType.COMMENTMEDIA, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> this.getSocialMediaCommentProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate()), c -> this.getSocialMediaCommentProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate())));
        this.providers.put(SocialInformationType.PUBLICATION, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> {
            List<SocialInformation> results = this.getSocialPublicationProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate());
            results.addAll(this.getSocialInformationsList(SocialInformationType.COMMENTPUBLICATION, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }, c -> {
            List<SocialInformation> results = this.getSocialPublicationProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate());
            results.addAll(this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTPUBLICATION, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }));
        this.providers.put(SocialInformationType.COMMENTPUBLICATION, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> {
            List<SocialInformation> results = this.getSocialPublicationCommentProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate());
            results.addAll(this.getSocialInformationsList(SocialInformationType.COMMENTNEWS, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }, c -> {
            List<SocialInformation> results = this.getSocialPublicationCommentProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate());
            results.addAll(this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTNEWS, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }));
        this.providers.put(SocialInformationType.COMMENTNEWS, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> this.getSocialNewsCommentProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate()), c -> this.getSocialNewsCommentProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate())));
        this.providers.put(SocialInformationType.COMMENT, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> {
            List<SocialInformation> results = this.getSocialInformationsList(SocialInformationType.COMMENTPUBLICATION, (SocialInformationProviderSwitcher.SocialInfoContext)c);
            results.addAll(this.getSocialInformationsList(SocialInformationType.COMMENTMEDIA, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }, c -> {
            List<SocialInformation> results = this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTPUBLICATION, (SocialInformationProviderSwitcher.SocialInfoContext)c);
            results.addAll(this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTMEDIA, (SocialInformationProviderSwitcher.SocialInfoContext)c));
            return results;
        }));
        this.providers.put(SocialInformationType.STATUS, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> this.getSocialStatusProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate()), c -> this.getSocialStatusProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate())));
        this.providers.put(SocialInformationType.RELATIONSHIP, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> this.getSocialRelationShipProvider().getSocialInformationList(c.getUserId(), c.getBeginDate(), c.getEndDate()), c -> this.getSocialRelationShipProvider().getSocialInformationListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate())));
        this.providers.put(SocialInformationType.LASTEVENT, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> this.getSocialEventsProvider().getMyLastSocialInformationsList(c.getUserId(), c.getBeginDate(), c.getEndDate()), c -> this.getSocialEventsProvider().getLastSocialInformationsListOfMyContacts(c.getUserId(), c.getContactIds(), c.getBeginDate(), c.getEndDate())));
        this.providers.put(SocialInformationType.ALL, (Pair<SocialInfoListSupplier, SocialInfoListSupplier>)Pair.of(c -> Stream.of(SocialInformationType.values()).filter(t -> !this.exclusion.contains(t)).flatMap(t -> this.getSocialInformationsList((SocialInformationType)((Object)((Object)t)), (SocialInformationProviderSwitcher.SocialInfoContext)c).stream()).collect(Collectors.toList()), c -> Stream.of(SocialInformationType.values()).filter(t -> !this.exclusion.contains(t)).flatMap(t -> this.getSocialInformationsListOfMyContacts((SocialInformationType)((Object)((Object)t)), (SocialInformationProviderSwitcher.SocialInfoContext)c).stream()).collect(Collectors.toList())));
    }

    @Override
    public List<SocialInformation> getSocialInformationsList(SocialInformationType socialInformationType, SocialInformationProviderSwitcher.SocialInfoContext context) {
        try {
            return (List)((SocialInfoListSupplier)this.providers.getOrDefault((Object)socialInformationType, NOTHING).getFirst()).apply(context);
        }
        catch (Exception ex) {
            throw new SocialNetworkException(ex);
        }
    }

    @Override
    public List<SocialInformation> getSocialInformationsListOfMyContacts(SocialInformationType socialInformationType, SocialInformationProviderSwitcher.SocialInfoContext context) {
        try {
            return (List)((SocialInfoListSupplier)this.providers.getOrDefault((Object)socialInformationType, NOTHING).getSecond()).apply(context);
        }
        catch (Exception ex) {
            throw new SocialNetworkException(ex);
        }
    }

    public SocialEventProvider getSocialEventsProvider() {
        return SocialEventProvider.get();
    }

    public SocialMediaProvider getSocialMediaProvider() {
        return SocialMediaProvider.get();
    }

    public SocialMediaCommentProvider getSocialMediaCommentProvider() {
        return SocialMediaCommentProvider.get();
    }

    public SocialPublicationProvider getSocialPublicationProvider() {
        return SocialPublicationProvider.get();
    }

    public SocialPublicationCommentProvider getSocialPublicationCommentProvider() {
        return SocialPublicationCommentProvider.get();
    }

    public SocialNewsCommentProvider getSocialNewsCommentProvider() {
        return SocialNewsCommentProvider.get();
    }

    public SocialStatusProvider getSocialStatusProvider() {
        return SocialStatusProvider.get();
    }

    public SocialRelationShipProvider getSocialRelationShipProvider() {
        return SocialRelationShipProvider.get();
    }

    @FunctionalInterface
    private static interface SocialInfoListSupplier
    extends Function<SocialInformationProviderSwitcher.SocialInfoContext, List<SocialInformation>> {
    }
}

