/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption.cipher;

import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.silverpeas.core.security.encryption.cipher.BlowfishKey;
import org.silverpeas.core.security.encryption.cipher.Cipher;
import org.silverpeas.core.security.encryption.cipher.CipherKey;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.core.security.encryption.cipher.CryptographicAlgorithmName;
import org.silverpeas.core.util.Charsets;

public class BlowfishCipher
implements Cipher {
    private final javax.crypto.Cipher cipher;
    private final BlowfishKey blowfishKey = new BlowfishKey();

    protected BlowfishCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        this.cipher = javax.crypto.Cipher.getInstance(CryptographicAlgorithmName.BLOWFISH.getId());
    }

    @Override
    public CryptographicAlgorithmName getAlgorithmName() {
        return CryptographicAlgorithmName.BLOWFISH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(String data, CipherKey keyCode) throws CryptoException {
        byte[] cipherText;
        try {
            byte[] cipherBytes = data.getBytes();
            BlowfishKey key = keyCode == null ? this.getSymmetricKey() : new BlowfishKey(keyCode.getRawKey());
            javax.crypto.Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(1, key);
                cipherText = this.cipher.doFinal(cipherBytes);
            }
        }
        catch (Exception e) {
            throw new CryptoException("The encryption failed!", e);
        }
        return cipherText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(byte[] cipher, CipherKey keyCode) throws CryptoException {
        String uncrypted;
        try {
            byte[] newPlainText;
            BlowfishKey key = keyCode == null ? this.getSymmetricKey() : new BlowfishKey(keyCode.getRawKey());
            javax.crypto.Cipher cipher2 = this.cipher;
            synchronized (cipher2) {
                this.cipher.init(2, key);
                newPlainText = this.cipher.doFinal(cipher);
            }
            uncrypted = new String(newPlainText, Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new CryptoException("The decryption failed!", e);
        }
        return uncrypted;
    }

    private BlowfishKey getSymmetricKey() {
        return this.blowfishKey;
    }

    @Override
    public CipherKey generateCipherKey() throws CryptoException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(CryptographicAlgorithmName.BLOWFISH.getId());
            SecretKey key = keyGenerator.generateKey();
            return CipherKey.aKeyFromBinary(key.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException("The generation of a cipher key failed!", ex);
        }
    }
}

