/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessController;

public abstract class AbstractAccessController<T>
implements AccessController<T> {
    public Stream<T> filterAuthorizedByUser(Collection<T> objects, String userId) {
        return this.filterAuthorizedByUser(objects, userId, AccessControlContext.init());
    }

    public Stream<T> filterAuthorizedByUser(Collection<T> objects, String userId, AccessControlContext context) {
        throw new UnsupportedOperationException();
    }

    public final boolean isUserAuthorized(String userId, T object) {
        return this.isUserAuthorized(userId, object, AccessControlContext.init());
    }

    public final Set<SilverpeasRole> getUserRoles(String userId, T object, AccessControlContext context) {
        String cacheKey = this.buildUserRoleCacheKey(context, userId, object);
        EnumSet<SilverpeasRole> userRoles = (EnumSet<SilverpeasRole>)context.get(cacheKey, Set.class);
        if (userRoles == null) {
            userRoles = EnumSet.noneOf(SilverpeasRole.class);
            this.fillUserRoles(userRoles, context, userId, object);
            context.put(cacheKey, userRoles);
        }
        return userRoles;
    }

    protected void fillUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, T object) {
        throw new UnsupportedOperationException();
    }

    private String buildUserRoleCacheKey(AccessControlContext context, String userId, T object) {
        StringBuilder cacheKey = new StringBuilder(this.getClass().getName()).append("@#@");
        cacheKey.append("USERID").append(userId).append("@#@");
        cacheKey.append("OBJECTID");
        if (object instanceof String) {
            cacheKey.append(object);
        } else if (object instanceof WAPrimaryKey) {
            WAPrimaryKey pk = (WAPrimaryKey)object;
            cacheKey.append(pk.getId()).append("|").append(pk.getInstanceId());
        } else if (object != null) {
            throw new UnsupportedOperationException();
        }
        EnumSet orderedOperations = EnumSet.copyOf(context.getOperations());
        cacheKey.append("@#@").append("OPERATIONS").append(String.join((CharSequence)"|", orderedOperations.stream().map(o -> Objects.toString(o, "")).collect(Collectors.toList())));
        return cacheKey.toString();
    }
}

