/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.popup;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.channel.AbstractListener;
import org.silverpeas.core.notification.user.server.channel.popup.PopupMessageService;
import org.silverpeas.kernel.logging.SilverLogger;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="CHANNEL='POPUP'"), @ActivationConfigProperty(propertyName="destinationLookup", propertyValue="jms/queue/notificationsQueue")}, description="Message driven bean for Pop UP notifications")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class POPUPListener
extends AbstractListener
implements MessageListener {
    public void onMessage(Message msg) {
        try {
            this.processMessage(msg);
        }
        catch (NotificationServerException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public void send(NotificationData message) throws NotificationServerException {
        try {
            PopupMessageService.get().push(message.getTargetReceipt(), message);
        }
        catch (Exception e) {
            throw new NotificationServerException(e);
        }
    }
}

