/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.builder;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TemporalFormatter;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.user.DefaultUserNotification;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.builder.AbstractResourceUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Link;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;

public abstract class AbstractTemplateUserNotificationBuilder<T>
extends AbstractResourceUserNotificationBuilder<T> {
    protected static final String CUSTOM_NOTIFICATION_SUBJECT = "custom.st.notification.subject";
    protected static final String DEFAULT_NOTIFICATION_SUBJECT = "GML.st.notification.subject";
    private final Map<String, SilverpeasTemplate> templates = new HashMap<String, SilverpeasTemplate>();
    private Pair<Boolean, String> rootTemplatePath;

    protected AbstractTemplateUserNotificationBuilder(T resource) {
        super(resource);
    }

    protected String getBundleSubjectKey() {
        return CUSTOM_NOTIFICATION_SUBJECT;
    }

    @Override
    protected final String getTitle() {
        return this.getTitle(I18NHelper.DEFAULT_LANGUAGE);
    }

    protected String getTitle(String language) {
        String subjectKey = this.getBundleSubjectKey();
        String subject = StringUtils.isBlank((CharSequence)subjectKey) || !this.getBundle().containsKey(subjectKey) ? this.getBundle(language).getString(DEFAULT_NOTIFICATION_SUBJECT) : this.getBundle(language).getString(subjectKey);
        return subject;
    }

    protected abstract String getTemplateFileName();

    @Override
    protected UserNotification createNotification() {
        return new DefaultUserNotification(this.getTitle(), this.templates, this.getTemplateFileName());
    }

    @Override
    protected final void performBuild(T resource) {
        this.templates.clear();
        this.perform(resource);
        NotificationResourceData nRDBase = this.initializeNotificationResourceData();
        for (String curLanguage : DisplayI18NHelper.getLanguages()) {
            String linkUrl;
            String linkLabel = "";
            if (this.getAction() == NotifAction.DELETE) {
                this.getNotificationMetaData().setLink(Link.EMPTY_LINK, curLanguage);
                linkUrl = null;
            } else {
                linkUrl = this.getResourceURL(resource);
                if (this.getContributionAccessLinkLabelBundleKey() != null) {
                    linkLabel = this.getBundle(curLanguage).getString(this.getContributionAccessLinkLabelBundleKey());
                }
                Link link = new Link(linkUrl, linkLabel);
                this.getNotificationMetaData().setLink(link, curLanguage);
            }
            SilverpeasTemplate template = this.createTemplate();
            template.setAttribute("silverpeasURL", (Object)linkUrl);
            template.setAttribute("resource", resource);
            this.templates.put(curLanguage, template);
            this.performTemplateData(curLanguage, resource, template);
            NotificationResourceData resourceData = new NotificationResourceData(nRDBase);
            resourceData.setCurrentLanguage(curLanguage);
            resourceData.setLinkLabel(linkLabel);
            this.performNotificationResource(curLanguage, resource, resourceData);
            this.getNotificationMetaData().setNotificationResourceData(curLanguage, resourceData);
        }
    }

    @Override
    protected final void performNotificationResource(T resource) {
    }

    @Override
    protected final void performNotificationResource(T resource, NotificationResourceData notificationResourceData) {
    }

    private Pair<Boolean, String> getRootTemplatePath() {
        if (this.rootTemplatePath == null) {
            Mutable componentRoot = Mutable.of((Object)false);
            Mutable templatePath = Mutable.of((Object)this.getTemplatePath());
            Optional instance = SilverpeasComponentInstance.getById((String)this.getComponentInstanceId());
            if (this instanceof FallbackToCoreTemplatePathBehavior) {
                instance.map(i -> i.getName() + "/" + (String)templatePath.get()).filter(p -> SilverpeasTemplates.isComponentTemplateExist((String)p, (String)this.getTemplateFileName())).ifPresent(p -> {
                    componentRoot.set((Object)true);
                    templatePath.set(p);
                });
            } else {
                componentRoot.set((Object)(instance.isPresent() || OrganizationControllerProvider.getOrganisationController().isToolAvailable(this.getComponentInstanceId()) ? 1 : 0));
            }
            this.rootTemplatePath = Pair.of((Object)((Boolean)componentRoot.get()), (Object)((String)templatePath.get()));
        }
        return this.rootTemplatePath;
    }

    private SilverpeasTemplate createTemplate() {
        boolean fromComponent = (Boolean)this.getRootTemplatePath().getFirst();
        String templatePath = (String)this.getRootTemplatePath().getSecond();
        if (fromComponent) {
            return SilverpeasTemplates.createSilverpeasTemplateOnComponents((String)templatePath);
        }
        return SilverpeasTemplates.createSilverpeasTemplateOnCore((String)templatePath);
    }

    protected void perform(T resource) {
    }

    protected abstract void performTemplateData(String var1, T var2, SilverpeasTemplate var3);

    protected abstract void performNotificationResource(String var1, T var2, NotificationResourceData var3);

    protected abstract String getTemplatePath();

    protected String getContributionAccessLinkLabelBundleKey() {
        return null;
    }

    public static class NotificationTemporal {
        final Temporal temporal;
        final ZoneId zoneIdReference;
        final String language;

        public NotificationTemporal(Temporal temporal, ZoneId zoneIdReference, String language) {
            this.temporal = temporal;
            this.zoneIdReference = zoneIdReference;
            this.language = language;
        }

        public boolean isDateExisting() {
            return this.temporal != null && this.temporal.isSupported(ChronoUnit.DAYS);
        }

        public String getDayDate() {
            return TemporalFormatter.toLocalized((Temporal)TemporalConverter.asLocalDate((Temporal)this.temporal), (String)this.language);
        }

        public String getDate() {
            return TemporalFormatter.toLocalized((Temporal)this.temporal, (String)this.language);
        }

        public String getFullDate() {
            return TemporalFormatter.toLocalized((Temporal)this.temporal, (ZoneId)this.zoneIdReference, (String)this.language);
        }

        public boolean isTimeExisting() {
            return this.temporal.isSupported(ChronoUnit.HOURS);
        }

        public String getDayTime() {
            String hour = "";
            if (this.isTimeExisting()) {
                hour = TemporalFormatter.toLocalizedTime((Temporal)this.temporal, (String)this.language);
            }
            return hour;
        }

        public String getZonedDayTime() {
            String hour = "";
            if (this.isTimeExisting()) {
                hour = TemporalFormatter.toLocalizedTime((Temporal)this.temporal, (ZoneId)this.zoneIdReference, (String)this.language);
            }
            return hour;
        }
    }
}

