/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.client.constant.NotifMessageType;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.logging.SilverLogger;

public class DefaultUserNotification
implements UserNotification {
    private final NotificationMetaData notification;

    public DefaultUserNotification() {
        this(null, null);
    }

    public DefaultUserNotification(String title, String content) {
        this.notification = StringUtils.isNotBlank((CharSequence)title) && StringUtils.isNotBlank((CharSequence)content) ? new NotificationMetaData(NotifMessageType.NORMAL.getId(), title, content) : new NotificationMetaData();
    }

    public DefaultUserNotification(String title, Map<String, SilverpeasTemplate> templates, String content) {
        this.notification = new NotificationMetaData(NotifMessageType.NORMAL.getId(), title, templates, content);
    }

    public NotificationMetaData getNotificationMetaData() {
        return this.notification;
    }

    public void send() {
        this.send(null);
    }

    public void send(BuiltInNotifAddress notificationAddress) {
        NotificationMetaData notifMetaData = this.getNotificationMetaData();
        if (notifMetaData != null) {
            try {
                NotificationSender sender = new NotificationSender(notifMetaData.getComponentId());
                if (notificationAddress != null) {
                    sender.notifyUser(notificationAddress.getId(), notifMetaData);
                } else {
                    sender.notifyUser(notifMetaData);
                }
            }
            catch (NotificationException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }
}

