/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.ImageToolException;
import org.silverpeas.core.io.media.image.option.AbstractImageToolOption;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractImageTool
implements ImageTool {
    private final Semaphore semaphore = new Semaphore(5, true);

    protected abstract void convert(File var1, File var2, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> var3, Set<ImageToolDirective> var4) throws SilverpeasException;

    @Override
    public void convert(File source, File destination, ImageToolDirective ... directives) {
        this.centralizedConvert(source, destination, null, directives);
    }

    @Override
    public void convert(File source, File destination, AbstractImageToolOption option, ImageToolDirective ... directives) {
        this.centralizedConvert(source, destination, Collections.singleton(option), directives);
    }

    @Override
    public void convert(File source, File destination, Set<AbstractImageToolOption> options, ImageToolDirective ... directives) {
        this.centralizedConvert(source, destination, options, directives);
    }

    private void centralizedConvert(File source, File destination, Set<AbstractImageToolOption> options, ImageToolDirective ... directives) {
        if (source.exists()) {
            if (destination == null) {
                destination = source;
            }
            try {
                this.semaphore.acquire();
                this.convert(source, destination, this.toMap(options), this.toSet(directives));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new ImageToolException(e);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    protected <T extends AbstractImageToolOption> T getOption(Map<?, ?> options, Class<T> key) {
        return (T)((AbstractImageToolOption)options.get(key));
    }

    private <T extends AbstractImageToolOption> Map<Class<T>, AbstractImageToolOption> toMap(Set<AbstractImageToolOption> options) {
        HashMap<Class<T>, AbstractImageToolOption> mappedOptions;
        if (options != null) {
            mappedOptions = new HashMap<Class<T>, AbstractImageToolOption>();
            for (AbstractImageToolOption option : options) {
                mappedOptions.put(option.getClass(), option);
            }
        } else {
            mappedOptions = new HashMap(0);
        }
        return mappedOptions;
    }

    private <T> Set<T> toSet(T ... items) {
        if (items == null) {
            return new HashSet(0);
        }
        return CollectionUtil.asSet((Object[])items);
    }
}

