/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.index.indexing.parser.DefaultParser;
import org.silverpeas.core.index.indexing.parser.Parser;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Technical
@Bean
@Singleton
public final class ParserManager {
    private final Map<String, Parser> parserMap = new HashMap<String, Parser>();
    @Inject
    @DefaultParser
    private Parser defaultParser;

    private ParserManager() {
    }

    @PostConstruct
    private void init() {
        try {
            SettingBundle parsersConfiguration = ResourceLocator.getSettingBundle((String)"org.silverpeas.index.indexing.Parser");
            Set mimeTypes = parsersConfiguration.keySet();
            for (String mimeType : mimeTypes) {
                String parserName = parsersConfiguration.getString(mimeType);
                if ("ignored".equals(parserName) || parserName.isEmpty()) continue;
                this.registerParser(parserName, mimeType);
            }
        }
        catch (MissingResourceException e) {
            IndexingLogger.indexingLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private void registerParser(String parserName, String mimeType) {
        try {
            Parser parser = (Parser)ServiceProvider.getService((String)parserName);
            this.parserMap.put(mimeType, parser);
        }
        catch (SilverpeasRuntimeException e) {
            IndexingLogger.indexingLogger().error("No parser found in silverpeas for {0}: {1}", new Object[]{mimeType, parserName});
        }
        catch (Exception e) {
            IndexingLogger.indexingLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public Optional<Parser> getParser(String mimeType) {
        return Optional.ofNullable(this.parserMap.getOrDefault(mimeType, this.defaultParser));
    }
}

