/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.index.indexing.model.IndexReadersCache;
import org.silverpeas.core.index.search.model.ParseException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class IndexProcessor {
    private static final SettingBundle searchSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.index.search.searchEngineSettings");
    private static final StampedLock SEARCH_LOCK = new StampedLock();
    private static final Object UPDATED_MUTEX = new Object();
    private static final Object MUTEX = new Object();
    private static final List<String> UPDATED_INDEXES = new ArrayList<String>();

    private IndexProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R doSearch(SearchIndexProcess<R> searchIndexProcess, Supplier<R> defaultReturn) throws ParseException {
        Object object;
        long stamp;
        SilverLogger logger = IndexingLogger.indexingLogger();
        Object object2 = MUTEX;
        synchronized (object2) {
            stamp = SEARCH_LOCK.tryReadLock();
            if (stamp == 0L) {
                logger.debug("starting and ending directly search processing because of index removing", new Object[0]);
            } else {
                logger.debug("starting search processing and there are currently {0} search process(es) performing", new Object[]{SEARCH_LOCK.getReadLockCount()});
            }
        }
        if (stamp == 0L) {
            return defaultReturn.get();
        }
        try {
            object2 = searchIndexProcess.process();
            object = MUTEX;
        }
        catch (Throwable throwable) {
            Object object3 = MUTEX;
            synchronized (object3) {
                SEARCH_LOCK.unlockRead(stamp);
                logger.debug("ending search processing and there are currently {0} search process(es) performing", new Object[]{SEARCH_LOCK.getReadLockCount()});
                IndexProcessor.closeIndexReaders();
            }
            throw throwable;
        }
        synchronized (object) {
            SEARCH_LOCK.unlockRead(stamp);
            logger.debug("ending search processing and there are currently {0} search process(es) performing", new Object[]{SEARCH_LOCK.getReadLockCount()});
            IndexProcessor.closeIndexReaders();
        }
        return (R)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doFlush(FlushIndexProcess flushIndexProcess) {
        List<String> updatedPaths = flushIndexProcess.process();
        Object object = UPDATED_MUTEX;
        synchronized (object) {
            UPDATED_INDEXES.addAll(updatedPaths);
        }
        object = MUTEX;
        synchronized (object) {
            IndexProcessor.closeIndexReaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doRemoveAll(RemoveAllIndexesProcess removeAllIndexesProcess) {
        long stamp = SEARCH_LOCK.writeLock();
        SilverLogger logger = IndexingLogger.indexingLogger();
        logger.debug("starting remove of all index entries", new Object[0]);
        try {
            logger.debug("closing all index readers", new Object[0]);
            IndexReadersCache.closeAllIndexReaders();
            logger.debug("removing indexes", new Object[0]);
            removeAllIndexesProcess.process();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        finally {
            SEARCH_LOCK.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeIndexReaders() {
        SilverLogger logger = IndexingLogger.indexingLogger();
        if (SEARCH_LOCK.getReadLockCount() == 0) {
            Object object = UPDATED_MUTEX;
            synchronized (object) {
                if (searchSettings.getBoolean("index.reader.closeAfterLastSearch", false)) {
                    logger.debug("no search is currently being performed, so closing all readers", new Object[0]);
                    IndexReadersCache.closeAllIndexReaders();
                    UPDATED_INDEXES.clear();
                } else {
                    logger.debug("no search is currently being performed, so closing readers if any", new Object[0]);
                    Iterator<String> it = UPDATED_INDEXES.iterator();
                    while (it.hasNext()) {
                        String path = it.next();
                        IndexReadersCache.closeIndexReader(path);
                        it.remove();
                    }
                }
            }
        } else {
            logger.debug("no reader close is performed as {0} search process(es) are currently performed", new Object[]{SEARCH_LOCK.getReadLockCount()});
        }
    }

    public static interface RemoveAllIndexesProcess {
        public void process() throws IOException;
    }

    public static interface FlushIndexProcess {
        public List<String> process();
    }

    public static interface SearchIndexProcess<R> {
        public R process() throws ParseException;
    }
}

