/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.template.publication;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.form.AbstractForm;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.dummy.DummyRecordSet;
import org.silverpeas.core.contribution.content.form.dummy.DummyRecordTemplate;
import org.silverpeas.core.contribution.content.form.form.HtmlForm;
import org.silverpeas.core.contribution.content.form.form.XmlForm;
import org.silverpeas.core.contribution.content.form.form.XmlSearchForm;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.content.form.record.GenericRecordTemplate;
import org.silverpeas.core.contribution.content.form.record.Label;
import org.silverpeas.core.contribution.content.form.record.Parameter;
import org.silverpeas.core.contribution.content.form.record.ParameterValue;
import org.silverpeas.core.contribution.content.form.record.Repeatable;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement(name="publicationTemplate")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PublicationTemplateImpl
implements PublicationTemplate {
    private static final String HTML_EXTENSION = ".html";
    @XmlElement(required=true)
    private String name = "";
    @XmlElement
    private String description = "";
    @XmlElement(name="image")
    private String thumbnail = "";
    @XmlElement(required=true, defaultValue="false")
    private boolean directoryUsage = false;
    @XmlElement(required=true, defaultValue="false")
    private boolean visible = false;
    @XmlElement(defaultValue="false")
    private boolean locked = false;
    @XmlElement(required=true, defaultValue="false")
    private boolean dataEncrypted = false;
    @XmlElementWrapper(name="spaces")
    @XmlElement(name="space")
    private List<String> spaces;
    @XmlElementWrapper(name="applications")
    @XmlElement(name="application")
    private List<String> applications;
    @XmlElementWrapper(name="instances")
    @XmlElement(name="instance")
    private List<String> instances;
    @XmlElementWrapper(name="domains")
    @XmlElement(name="domain")
    private List<String> domains;
    @XmlElementWrapper(name="groups")
    @XmlElement(name="group")
    private List<String> groups;
    @XmlElement
    private String viewFileName = "";
    @XmlElement
    private String updateFileName = "";
    @XmlElement
    private String searchFileName = "";
    @XmlElement
    private String dataFileName = "";
    @XmlElement
    private String viewTypeFile = "";
    @XmlElement
    private String updateTypeFile = "";
    private String fileName = "";
    private String externalId = "";
    @XmlElement
    private String searchResultFileName = "";
    private RecordTemplate template = null;
    private RecordTemplate searchTemplate = null;
    private RecordTemplate viewTemplate = null;
    private RecordTemplate updateTemplate = null;
    private RecordTemplate searchResultTemplate = null;
    private RecordSet recordSet = null;
    private Form updateForm = null;
    private Form viewForm = null;
    private Form searchResultForm = null;
    public static final int LAYER_ACTION_NONE = 0;
    public static final int LAYER_ACTION_ADD = 1;
    public static final int LAYER_ACTION_REMOVE = 2;
    private int viewLayerAction = 0;
    private int updateLayerAction = 0;
    private String viewLayerFileName = "";
    private String updateLayerFileName = "";
    private static JAXBContext jaxbContext = null;

    public RecordTemplate getRecordTemplate(boolean loadIfNull) throws PublicationTemplateException {
        if (this.template != null || !loadIfNull) {
            return this.template;
        }
        RecordTemplate tmpl = this.loadRecordTemplate(this.dataFileName);
        if (tmpl != null && !(tmpl instanceof DummyRecordTemplate)) {
            this.template = tmpl;
        }
        return tmpl;
    }

    @Override
    public RecordTemplate getRecordTemplate() throws PublicationTemplateException {
        return this.getRecordTemplate(true);
    }

    @Override
    public RecordSet getRecordSet() throws PublicationTemplateException {
        try {
            if (this.recordSet != null) {
                return this.recordSet;
            }
            RecordSet rs = this.getGenericRecordSetManager().getRecordSet(this.externalId);
            if (rs != null && !(rs instanceof DummyRecordSet)) {
                this.recordSet = rs;
            }
            if (this.template != null && rs instanceof DummyRecordSet) {
                rs = new DummyRecordSet(this.template);
            }
            return rs;
        }
        catch (FormException e) {
            throw new PublicationTemplateException((Throwable)((Object)e));
        }
    }

    @Override
    public Form getUpdateForm() throws PublicationTemplateException {
        if (this.updateForm == null) {
            this.updateForm = this.getForm(this.updateFileName, this.updateTypeFile);
        }
        return this.updateForm;
    }

    @Override
    public XmlForm getUpdateFormAsXMLOne() throws PublicationTemplateException {
        return (XmlForm)this.getForm(this.updateFileName.replaceAll(HTML_EXTENSION, ".xml"), "xml");
    }

    @Override
    public Form getViewForm() throws PublicationTemplateException {
        if (this.viewForm == null) {
            this.viewForm = this.getForm(this.viewFileName, this.viewTypeFile, true);
        }
        return this.viewForm;
    }

    public RecordTemplate getSearchTemplate(boolean loadIfNull) throws PublicationTemplateException {
        if (this.searchTemplate == null && loadIfNull) {
            this.searchTemplate = this.loadRecordTemplate(this.searchFileName);
        }
        return this.searchTemplate;
    }

    @Override
    public RecordTemplate getSearchTemplate() throws PublicationTemplateException {
        return this.getSearchTemplate(true);
    }

    public RecordTemplate getViewTemplate() {
        return this.viewTemplate;
    }

    public RecordTemplate getUpdateTemplate() {
        return this.updateTemplate;
    }

    public RecordTemplate getDataTemplate() throws PublicationTemplateException {
        return this.getRecordTemplate(false);
    }

    @Override
    public Form getSearchForm() throws PublicationTemplateException {
        XmlSearchForm searchForm = null;
        if (this.isSearchable()) {
            RecordTemplate templateForm = this.loadRecordTemplate(this.searchFileName);
            try {
                searchForm = new XmlSearchForm(templateForm);
                searchForm.setFormName(FilenameUtils.getBaseName((String)this.fileName));
            }
            catch (FormException e) {
                throw new PublicationTemplateException((Throwable)((Object)e));
            }
        }
        return searchForm;
    }

    private Form getForm(String fileName, String fileType) throws PublicationTemplateException {
        return this.getForm(fileName, fileType, false);
    }

    private Form getForm(String fileName, String fileType, boolean viewForm) throws PublicationTemplateException {
        AbstractForm form;
        String currentFileName = fileName;
        String typeFile = FileRepositoryManager.getFileExtension(currentFileName);
        if (StringUtil.isDefined((String)fileType)) {
            typeFile = fileType.trim().toLowerCase();
        }
        if (StringUtil.isDefined((String)currentFileName) && "xml".equals(typeFile)) {
            RecordTemplate templateForm = this.loadRecordTemplate(currentFileName);
            this.mergeTemplate(templateForm);
            try {
                form = new XmlForm(templateForm, viewForm);
            }
            catch (FormException e) {
                throw new PublicationTemplateException((Throwable)((Object)e));
            }
        }
        PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
        String htmlFileName = templateManager.makePath(currentFileName);
        currentFileName = currentFileName.replaceAll(HTML_EXTENSION, ".xml");
        RecordTemplate templateForm = this.loadRecordTemplate(currentFileName);
        this.mergeTemplate(templateForm);
        try {
            HtmlForm viewFormHtml = new HtmlForm(templateForm);
            viewFormHtml.setFileName(htmlFileName);
            form = viewFormHtml;
        }
        catch (FormException e) {
            throw new PublicationTemplateException((Throwable)((Object)e));
        }
        form.setFormName(FilenameUtils.getBaseName((String)this.fileName));
        form.setTitle(this.getName());
        return form;
    }

    private void mergeTemplate(RecordTemplate formTemplate) throws PublicationTemplateException {
        RecordTemplate dataTemplate = this.getRecordTemplate();
        if (formTemplate != null && dataTemplate != null) {
            String[] fieldNames;
            for (String fieldName : fieldNames = formTemplate.getFieldNames()) {
                try {
                    GenericFieldTemplate formFieldTemplate = (GenericFieldTemplate)formTemplate.getFieldTemplate(fieldName);
                    GenericFieldTemplate dataFieldTemplate = (GenericFieldTemplate)dataTemplate.getFieldTemplate(fieldName);
                    formFieldTemplate.setTypeName(dataFieldTemplate.getTypeName());
                    formFieldTemplate.setParametersObj(dataFieldTemplate.getParameters());
                    formFieldTemplate.setLabelsObj(dataFieldTemplate.getLabelsObj());
                }
                catch (FormException e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
                }
            }
        }
    }

    public void setViewFileName(String viewFileName) {
        this.viewFileName = viewFileName;
    }

    public String getViewFileName() {
        return this.viewFileName;
    }

    public void setUpdateFileName(String updateFileName) {
        this.updateFileName = updateFileName;
    }

    public String getUpdateTypeFile() {
        return this.updateTypeFile;
    }

    public void setUpdateTypeFile(String updateTypeFile) {
        this.updateTypeFile = updateTypeFile;
    }

    public String getViewTypeFile() {
        return this.viewTypeFile;
    }

    public void setViewTypeFile(String viewTypeFile) {
        this.viewTypeFile = viewTypeFile;
    }

    public String getUpdateFileName() {
        return this.updateFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    public RecordTemplate loadRecordTemplate(String xmlFileName) throws PublicationTemplateException {
        if (!StringUtil.isDefined((String)xmlFileName)) {
            return null;
        }
        PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
        String filePath = templateManager.makePath(xmlFileName);
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GenericRecordTemplate recordTemplate = (GenericRecordTemplate)unmarshaller.unmarshal(new File(filePath));
            recordTemplate.setTemplateName(this.fileName.substring(0, this.fileName.lastIndexOf(46)));
            return recordTemplate;
        }
        catch (JAXBException e) {
            throw new PublicationTemplateException("Fail to unmarshal publication template " + xmlFileName, e);
        }
    }

    public void saveRecordTemplates() throws PublicationTemplateException {
        String subDir = this.fileName.substring(0, this.fileName.lastIndexOf(46)) + File.separator;
        if (this.template != null) {
            this.saveRecordTemplate(this.template, subDir, "data.xml");
        }
        if (this.viewTemplate != null) {
            this.saveRecordTemplate(this.viewTemplate, subDir, "view.xml");
        }
        if (this.updateTemplate != null) {
            this.saveRecordTemplate(this.updateTemplate, subDir, "update.xml");
        }
        if (this.searchTemplate != null) {
            this.saveRecordTemplate(this.searchTemplate, subDir, "search.xml");
        }
        if (this.searchResultTemplate != null) {
            this.saveRecordTemplate(this.searchResultTemplate, subDir, "searchresult.xml");
        }
    }

    private void saveRecordTemplate(RecordTemplate recordTemplate, String subDir, String xmlFileName) throws PublicationTemplateException {
        try {
            PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
            String xmlFilePath = templateManager.makePath(subDir + xmlFileName);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)recordTemplate, new File(xmlFilePath));
        }
        catch (JAXBException e) {
            throw new PublicationTemplateException("Fail to marshall publication template " + xmlFileName, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean isDirectoryUsage() {
        return this.directoryUsage;
    }

    public void setDirectoryUsage(boolean directoryUsage) {
        this.directoryUsage = directoryUsage;
    }

    public String getSearchFileName() {
        return this.searchFileName;
    }

    public void setSearchFileName(String searchFileName) {
        this.searchFileName = searchFileName;
    }

    public void setSearchTemplate(RecordTemplate searchTemplate) {
        this.searchTemplate = searchTemplate;
    }

    public void setTemplate(RecordTemplate template) {
        this.template = template;
    }

    public void setUpdateTemplate(RecordTemplate updateTemplate) {
        this.updateTemplate = updateTemplate;
    }

    public void setViewTemplate(RecordTemplate viewTemplate) {
        this.viewTemplate = viewTemplate;
    }

    public String getSearchResultFileName() {
        return this.searchResultFileName;
    }

    public void setSearchResultFileName(String searchResultFileName) {
        this.searchResultFileName = searchResultFileName;
    }

    @Override
    public boolean isSearchable() {
        return this.searchFileName != null && !this.searchFileName.trim().isEmpty();
    }

    public RecordTemplate getSearchResultTemplate() {
        return this.searchResultTemplate;
    }

    public void setSearchResultTemplate(RecordTemplate searchResultTemplate) {
        this.searchResultTemplate = searchResultTemplate;
    }

    public PublicationTemplateImpl basicClone() {
        PublicationTemplateImpl cloneTemplate = new PublicationTemplateImpl();
        cloneTemplate.setName(this.getName());
        cloneTemplate.setDescription(this.getDescription());
        cloneTemplate.setThumbnail(this.getThumbnail());
        cloneTemplate.setFileName(this.getFileName());
        cloneTemplate.setVisible(this.isVisible());
        cloneTemplate.setLocked(this.isLocked());
        cloneTemplate.setDataEncrypted(this.isDataEncrypted());
        cloneTemplate.setViewFileName(this.getViewFileName());
        cloneTemplate.setUpdateFileName(this.getUpdateFileName());
        cloneTemplate.setSearchFileName(this.getSearchFileName());
        cloneTemplate.setDataFileName(this.getDataFileName());
        cloneTemplate.setViewTypeFile(this.getViewTypeFile());
        cloneTemplate.setUpdateTypeFile(this.getUpdateTypeFile());
        cloneTemplate.setExternalId(this.getExternalId());
        cloneTemplate.setSearchResultFileName(this.getSearchResultFileName());
        cloneTemplate.setSpaces(this.getSpaces());
        cloneTemplate.setApplications(this.getApplications());
        cloneTemplate.setInstances(this.getInstances());
        cloneTemplate.setDomains(this.getDomains());
        cloneTemplate.setGroups(this.getGroups());
        cloneTemplate.setDirectoryUsage(this.isDirectoryUsage());
        cloneTemplate.setViewLayerFileName(this.getViewLayerFileName());
        cloneTemplate.setUpdateLayerFileName(this.getUpdateLayerFileName());
        return cloneTemplate;
    }

    protected GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    @Override
    public Form getSearchResultForm() throws PublicationTemplateException {
        if (this.searchResultForm == null) {
            this.searchResultForm = this.getForm(this.searchResultFileName, null);
        }
        return this.searchResultForm;
    }

    @Override
    public List<String> getFieldsForFacets() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            FieldTemplate[] fieldTemplates;
            for (FieldTemplate fieldTemplate : fieldTemplates = this.getRecordTemplate().getFieldTemplates()) {
                if (!fieldTemplate.isUsedAsFacet()) continue;
                fieldNames.add(fieldTemplate.getFieldName());
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        return fieldNames;
    }

    @Override
    public List<String> getSpaces() {
        return this.spaces;
    }

    @Override
    public boolean isRestrictedVisibilityToSpace() {
        return this.getSpaces() != null && !this.getSpaces().isEmpty();
    }

    @Override
    public boolean isRestrictedVisibilityToApplication() {
        return this.getApplications() != null && !this.getApplications().isEmpty();
    }

    @Override
    public boolean isRestrictedVisibilityToInstance() {
        return this.getInstances() != null && !this.getInstances().isEmpty();
    }

    public void setSpaces(List<String> spaces) {
        this.spaces = spaces;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    public void setApplications(List<String> applications) {
        this.applications = applications;
    }

    @Override
    public List<String> getInstances() {
        return this.instances;
    }

    public void setInstances(List<String> instances) {
        this.instances = instances;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    @Override
    public List<String> getDomains() {
        return this.domains;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public boolean isVisibleToDomain(String domainId) {
        return CollectionUtil.isEmpty(this.getDomains()) || this.getDomains().contains(domainId);
    }

    @Override
    public boolean isVisibleToUser(String userId) {
        if (CollectionUtil.isEmpty(this.getGroups())) {
            return this.isVisibleToDomain(User.getById((String)userId).getDomainId());
        }
        String[] groupIds = OrganizationController.get().getAllGroupIdsOfUser(userId);
        return !CollectionUtil.intersection(this.getGroups(), Arrays.asList(groupIds)).isEmpty();
    }

    @Override
    public boolean isRestrictedVisibility() {
        return this.isRestrictedVisibilityToSpace() || this.isRestrictedVisibilityToApplication() || this.isRestrictedVisibilityToInstance();
    }

    public void setDataEncrypted(boolean dataEncrypted) {
        this.dataEncrypted = dataEncrypted;
    }

    @Override
    public boolean isDataEncrypted() {
        return this.dataEncrypted;
    }

    public int getViewLayerAction() {
        return this.viewLayerAction;
    }

    public void setViewLayerAction(int viewLayerAction) {
        this.viewLayerAction = viewLayerAction;
    }

    public int getUpdateLayerAction() {
        return this.updateLayerAction;
    }

    public void setUpdateLayerAction(int updateLayerAction) {
        this.updateLayerAction = updateLayerAction;
    }

    public String getViewLayerFileName() {
        return this.viewLayerFileName;
    }

    public void setViewLayerFileName(String viewLayerFileName) {
        this.viewLayerFileName = viewLayerFileName;
    }

    public String getUpdateLayerFileName() {
        return this.updateLayerFileName;
    }

    public void setUpdateLayerFileName(String updateLayerFileName) {
        this.updateLayerFileName = updateLayerFileName;
    }

    public boolean isViewLayerDefined() {
        return StringUtil.isDefined((String)this.viewLayerFileName);
    }

    public boolean isUpdateLayerDefined() {
        return StringUtil.isDefined((String)this.updateLayerFileName);
    }

    @Override
    public boolean isViewLayerExist() {
        return this.getViewFileName().endsWith(HTML_EXTENSION);
    }

    @Override
    public boolean isUpdateLayerExist() {
        return this.getUpdateFileName().endsWith(HTML_EXTENSION);
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GenericRecordTemplate.class, GenericFieldTemplate.class, Label.class, Parameter.class, ParameterValue.class, Repeatable.class});
        }
        catch (JAXBException e) {
            SilverLogger.getLogger(PublicationTemplateImpl.class).error(e.getMessage(), (Throwable)e);
        }
    }
}

