/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractFieldDisplayer<T extends Field>
implements FieldDisplayer<T> {
    @Override
    public List<String> update(List<FileItem> items, T field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        String value = FileUploadUtil.getParameter(items, fieldName, null, pageContext.getEncoding());
        return this.applyUpdate(field, value, template, pageContext);
    }

    protected List<String> applyUpdate(T field, String value, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (pagesContext.getUpdatePolicy() == 1 && !StringUtil.isDefined((String)value)) {
            return new ArrayList<String>(0);
        }
        return this.update(value, field, template, pagesContext);
    }

    @Override
    public void index(FullIndexEntry indexEntry, String key, String fieldName, T field, String language, boolean stored) {
        String value;
        if (field != null && (value = field.getStringValue()) != null) {
            value = value.trim().replace("##", " ");
            indexEntry.addField(key, value, language, stored);
            indexEntry.addTextContent(value, language);
        }
    }

    static void produceMandatoryCheck(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        if (template.isMandatory() && pagesContext.useMandatory()) {
            String language = pagesContext.getLanguage();
            String label = WebEncodeHelper.javaStringToJsString((String)template.getLabel(language));
            out.println("   if (!ignoreMandatory && isWhitespace(stripInitialWhitespace(field.value))) {\n");
            out.println("      errorMsg+=\"  - '" + label + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";\n");
            out.println("      errorNb++;\n");
            out.println("   }\n");
        }
    }

    protected String getDefaultValue(FieldTemplate template, PagesContext pageContext) {
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String defaultParam = parameters.getOrDefault("default", "");
        return (pageContext.isCreation() || pageContext.isDesignMode()) && !pageContext.isIgnoreDefaultValues() ? defaultParam : "";
    }

    protected static img getMandatoryIcon(FieldTemplate template, PagesContext pageContext) {
        img image = null;
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            image = new img();
            image.setSrc(Util.getIcon("mandatoryField"));
            image.setWidth(5);
            image.setHeight(5);
            image.setBorder(0);
        }
        return image;
    }

    protected static Printable initInputField(FieldTemplate template, input inputField, PagesContext pageContext) {
        if (template.isDisabled()) {
            inputField.setDisabled(true);
        } else if (template.isReadOnly()) {
            inputField.setReadOnly(true);
        }
        img image = AbstractFieldDisplayer.getMandatoryIcon(template, pageContext);
        if (image != null) {
            ElementContainer container = new ElementContainer();
            container.addElement((Element)inputField);
            container.addElement("&nbsp;");
            container.addElement((Element)image);
            return container;
        }
        return inputField;
    }
}

