/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chart;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.chart.AbstractAxisChartItem;
import org.silverpeas.core.chart.AbstractChart;
import org.silverpeas.core.chart.ChartAxis;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public abstract class AbstractAxisChart<X, Y, I extends AbstractAxisChartItem<X, Y, I>>
extends AbstractChart<I> {
    private ChartAxis x = new ChartAxis();
    private ChartAxis y = new ChartAxis();
    private Map<X, I> itemIndexedByX = new HashMap<X, I>();

    public ChartAxis getAxisX() {
        return this.x;
    }

    public ChartAxis getAxisY() {
        return this.y;
    }

    @Override
    protected void computeExtraDataAsJson(JSONCodec.JSONObject jsonChart) {
        super.computeExtraDataAsJson(jsonChart);
        jsonChart.putJSONObject("axis", axes -> {
            axes.putJSONObject("x", this.getAxisX().asJson());
            axes.putJSONObject("y", this.getAxisY().asJson());
            return axes;
        });
    }

    protected I getItemFrom(X xValue) {
        return (I)((AbstractAxisChartItem)this.itemIndexedByX.get(xValue));
    }

    @Override
    protected <T extends AbstractChart<I>> T add(I item) {
        this.itemIndexedByX.put(((AbstractAxisChartItem)item).getX(), item);
        return super.add(item);
    }

    private I createFor(X x) {
        try {
            Class xClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Class itemClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
            Constructor constructor = itemClass.getDeclaredConstructor(xClass);
            constructor.trySetAccessible();
            return (I)((AbstractAxisChartItem)constructor.newInstance(x));
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public I forX(X xValue) {
        I item = this.getItemFrom(xValue);
        if (item == null) {
            item = this.createFor(xValue);
            this.add(item);
        }
        return item;
    }
}

