/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.repository;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.repository.CalendarEventOccurrenceRepository;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;

@Singleton
@Repository
public class DefaultCalendarEventOccurrenceRepository
extends BasicJpaEntityRepository<CalendarEventOccurrence>
implements CalendarEventOccurrenceRepository {
    private static final String EVENT_PARAM = "event";

    public List<CalendarEventOccurrence> getAllByEvent(CalendarEvent event) {
        NamedParameters parameters = this.newNamedParameters().add(EVENT_PARAM, (Object)event);
        return this.findByNamedQuery("occurrenceByEvent", parameters);
    }

    public List<CalendarEventOccurrence> getAll(Collection<CalendarEvent> events, Period period) {
        if (events.isEmpty()) {
            return Collections.emptyList();
        }
        NamedParameters parameters = this.newNamedParameters().add("events", events).add("startDateTime", (Object)TemporalConverter.asInstant((Temporal)period.getStartDate())).add("endDateTime", (Object)TemporalConverter.asInstant((Temporal)period.getEndDate()));
        return this.findByNamedQuery("occurrenceByEventsAndByPeriod", parameters);
    }

    public List<CalendarEventOccurrence> getAllSince(CalendarEventOccurrence occurrence) {
        NamedParameters parameters = this.newNamedParameters().add(EVENT_PARAM, (Object)occurrence.getCalendarEvent()).add("date", (Object)TemporalConverter.asInstant((Temporal)occurrence.getStartDate()));
        return this.findByNamedQuery("occurrenceByEventSince", parameters);
    }
}

