/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification.user;

import javax.enterprise.event.Observes;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.ICalendarEventSynchronization;
import org.silverpeas.core.notification.user.SimpleUserNotification;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.Pair;

public class CalendarBatchSynchronizationErrorUserNotification {
    private static final String TITLE_KEY = "calendar.notification.synchronization.error.title";
    private static final String LINK_LABEL_KEY = "calendar.link.label";
    private static final Pair<String, String> TEMPLATE_PATH = Pair.of((Object)"calendar", (Object)"calendarSynchronizationError");

    public void onEvent(@Observes ICalendarEventSynchronization.CalendarBatchSynchronizationErrorEvent event) {
        Calendar calendar = event.getCalendar();
        SimpleUserNotification.fromSystem().andComponentInstanceId(calendar.getComponentInstanceId()).toUsers(calendar.getCreator()).withTitle(l -> this.bundle((String)l).getStringWithParams(TITLE_KEY, new Object[]{calendar.getTitle()})).fillTemplate(TEMPLATE_PATH, (t, l) -> t.setAttribute("calendarTitle", (Object)calendar.getTitle())).withLink(l -> new Link(URLUtil.getComponentInstanceURL(calendar.getComponentInstanceId()) + "Main", this.bundle((String)l).getString(LINK_LABEL_KEY))).send();
    }

    private LocalizationBundle bundle(String locale) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.calendar.multilang.usernotification", (String)locale);
    }
}

