/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.util.Optional;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarPath;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.util.ContributionPath;

public class CalendarComponentPath
extends ContributionPath<Contribution> {
    private static final long serialVersionUID = -8183907269010658005L;

    private CalendarComponentPath(Contribution contribution) {
        super(1);
        this.add(contribution);
    }

    public static CalendarComponentPath getPath(CalendarEvent event) {
        return new CalendarComponentPath((Contribution)event);
    }

    public static CalendarComponentPath getPath(CalendarEventOccurrence occurrence) {
        return new CalendarComponentPath((Contribution)occurrence);
    }

    @Override
    protected boolean isRoot(Contribution contribution) {
        return false;
    }

    @Override
    protected String getLabel(Contribution contribution, String language) {
        return contribution.getTitle();
    }

    @Override
    public String format(String language, boolean fullSpacePath, String pathSep) {
        return Optional.ofNullable((Contribution)this.get(0)).map(this::asCalendarComponent).map(CalendarComponent::getCalendar).map(CalendarPath::getPath).map(p -> p.format(language, fullSpacePath, pathSep) + pathSep + super.format(language, fullSpacePath, pathSep)).orElse("");
    }

    private CalendarComponent asCalendarComponent(Contribution contribution) {
        if (contribution instanceof PlannedOnCalendar) {
            return ((PlannedOnCalendar)contribution).asCalendarComponent();
        }
        return null;
    }
}

