/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserReference;
import org.silverpeas.core.admin.user.service.UserProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;

@Provider
public class DefaultUserProvider
implements UserProvider {
    private static final UserDetail systemUser = new UserDetail();

    public User getUser(String userId) {
        if ("-1".equals(userId)) {
            return this.getSystemUser();
        }
        return OrganizationController.get().getUserDetail(userId);
    }

    public User getUserByToken(@Nonnull String token) {
        Objects.requireNonNull(token);
        PersistentResourceToken userToken = PersistentResourceToken.getToken((String)token);
        UserReference userRef = (UserReference)userToken.getResource(UserReference.class);
        return userRef == null ? null : userRef.getEntity();
    }

    public User getUserByLoginAndDomainId(@Nonnull String login, @Nonnull String domainId) {
        Objects.requireNonNull(login);
        Objects.requireNonNull(domainId);
        try {
            String userId = Administration.get().getUserIdByLoginAndDomain(login, domainId);
            return this.getUser(userId);
        }
        catch (AdminException e) {
            return null;
        }
    }

    public User getSystemUser() {
        return systemUser;
    }

    static {
        systemUser.setId("-1");
        systemUser.setFirstName("");
        systemUser.setLastName("SYSTEM");
        systemUser.setLogin("avatar-system");
        systemUser.setAccessLevel(UserAccessLevel.ADMINISTRATOR);
    }
}

