/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.quota.process.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.offset.SimpleQuotaCountingOffset;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceServiceProvider;
import org.silverpeas.core.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.core.admin.space.quota.process.check.SpaceDataStorageQuotaCountingOffset;
import org.silverpeas.core.admin.space.quota.process.check.exception.DataStorageQuotaException;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.process.annotation.SimulationActionProcessProcessor;
import org.silverpeas.core.process.io.IOAccess;
import org.silverpeas.core.process.io.file.FileHandler;
import org.silverpeas.core.process.management.AbstractFileProcessCheck;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class DataStorageQuotaProcessCheck
extends AbstractFileProcessCheck {
    private static final boolean DATA_STORAGE_IN_SPACE_QUOTA_ACTIVATED;
    private static final String PREVIOUS_CACHE_KEY = "DataStorageQuotaProcessCheck@previous@key";
    @Inject
    private OrganizationController organizationController;

    @Override
    public void checkFiles(ProcessExecutionContext processExecutionContext, FileHandler fileHandler) {
        if (!DATA_STORAGE_IN_SPACE_QUOTA_ACTIVATED) {
            return;
        }
        if (IOAccess.READ_WRITE.equals((Object)fileHandler.getIoAccess())) {
            Collection<SpaceInst> spaces = this.identifyHandledSpaces(processExecutionContext, fileHandler);
            Map previousSpaceOffsets = (Map)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)PREVIOUS_CACHE_KEY, Map.class, () -> new HashMap(spaces.size()));
            Objects.requireNonNull(previousSpaceOffsets);
            for (SpaceInst space : spaces) {
                try {
                    String spaceId = space.getId();
                    SimpleQuotaCountingOffset previousOffset = previousSpaceOffsets.computeIfAbsent(spaceId, k -> SimpleQuotaCountingOffset.from(0L));
                    long spaceOffset = SpaceDataStorageQuotaCountingOffset.from(space, fileHandler).getOffset();
                    SimpleQuotaCountingOffset currentOffset = SimpleQuotaCountingOffset.from(SimulationActionProcessProcessor.get().isSimulationProcessPerforming() ? spaceOffset + previousOffset.getOffset() : spaceOffset);
                    SpaceServiceProvider.getDataStorageSpaceQuotaService().verify(DataStorageSpaceQuotaKey.from(space), space.getDataStorageQuota(), currentOffset);
                    previousSpaceOffsets.put(spaceId, currentOffset);
                }
                catch (QuotaException quotaException) {
                    SilverLogger.getLogger((Object)this).silent((Throwable)((Object)quotaException));
                    SilverpeasComponentInstance fromComponent = null;
                    String fromComponentInstanceId = processExecutionContext.getComponentInstanceId();
                    if (StringUtil.isDefined((String)fromComponentInstanceId)) {
                        fromComponent = this.organizationController.getComponentInstance(fromComponentInstanceId).orElse(null);
                    }
                    DataStorageQuotaException exception = new DataStorageQuotaException(quotaException.getQuota(), space, fromComponent);
                    MessageNotifier.addSevere((String)SilverpeasTransverseErrorUtil.performExceptionMessage(exception, MessageManager.getLanguage()), (Object[])new Object[0]);
                    throw exception;
                }
            }
        }
    }

    private Collection<SpaceInst> identifyHandledSpaces(ProcessExecutionContext processExecutionContext, FileHandler fileHandler) {
        HashSet spaceIds = new HashSet();
        Set<String> componentInstanceIds = this.identifyComponentInstances(processExecutionContext, fileHandler);
        for (String componentInstanceId : componentInstanceIds) {
            this.organizationController.getComponentInstance(componentInstanceId).ifPresent(i -> spaceIds.add(i.getSpaceId()));
        }
        ArrayList<SpaceInst> handledSpaces = new ArrayList<SpaceInst>();
        for (String spaceId : spaceIds) {
            SpaceInst handledSpace = this.organizationController.getSpaceInstById(spaceId);
            if (!handledSpace.getDataStorageQuota().isNotUnlimitedLoad()) continue;
            handledSpaces.add(handledSpace);
        }
        return handledSpaces;
    }

    static {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.jobStartPagePeas.settings.jobStartPagePeasSettings");
        DATA_STORAGE_IN_SPACE_QUOTA_ACTIVATED = settings.getBoolean("quota.space.datastorage.activated", false);
    }
}

