/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.ParameterList;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class PersonalSpaceManager {
    private static final String MESSAGES_LOCATION = "org.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle";

    protected PersonalSpaceManager() {
    }

    public static PersonalSpaceManager get() {
        return (PersonalSpaceManager)ServiceProvider.getService(PersonalSpaceManager.class, (Annotation[])new Annotation[0]);
    }

    public List<PersonalComponentInstance> getVisiblePersonalComponentInstances(User user) {
        Collection<PersonalComponent> personalComponents = PersonalComponent.getAll();
        return personalComponents.stream().filter(PersonalComponent::isVisible).map(personalComponent -> PersonalComponentInstance.from(user, personalComponent)).collect(Collectors.toList());
    }

    public List<WAComponent> getVisibleComponents() {
        Collection<WAComponent> components = WAComponent.getAll();
        return components.stream().filter(WAComponent::isVisibleInPersonalSpace).collect(Collectors.toList());
    }

    public SpaceInst getOrCreatePersonalSpace(User user) {
        SpaceInst space = this.getPersonalSpace(user.getId());
        if (space == null) {
            String userId = user.getId();
            space = new SpaceInst();
            space.setCreatorUserId(userId);
            space.setInheritanceBlocked(true);
            space.setLevel(0);
            space.setName("Personal space of user #" + userId);
            space.setPersonalSpace(true);
            SpaceProfileInst profile = new SpaceProfileInst();
            profile.setName("admin");
            profile.addUser(userId);
            profile.setInherited(false);
            space.addSpaceProfileInst(profile);
            try {
                AdministrationServiceProvider.getAdminService().addSpaceInst(userId, space);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }
        return space;
    }

    public String addComponent(User user, String componentName) throws AdminException, QuotaException {
        Optional<WAComponent> optionalWAComponent = WAComponent.getByName(componentName);
        if (optionalWAComponent.isEmpty() || !optionalWAComponent.get().isVisibleInPersonalSpace()) {
            LocalizationBundle messages = this.getMessages(user.getUserPreferences().getLanguage());
            String errorText = messages.getString("JSPP.ErrorUnknownComponent");
            throw new AdminException(MessageFormat.format(errorText, componentName), new String[0]);
        }
        WAComponent wac = optionalWAComponent.get();
        String userId = user.getId();
        ComponentInst component = new ComponentInst();
        component.setCreatorUserId(userId);
        component.setInheritanceBlocked(false);
        component.setName(wac.getName());
        component.setLabel(wac.getLabel(DisplayI18NHelper.getDefaultLanguage()));
        ParameterList parameters = wac.getAllParameters();
        for (Parameter parameter : parameters) {
            if (!StringUtil.isDefined((String)parameter.getPersonalSpaceValue())) continue;
            parameter.setValue(parameter.getPersonalSpaceValue());
        }
        component.setParameters(parameters);
        SpaceInst space = this.getOrCreatePersonalSpace(user);
        component.setDomainFatherId(space.getId());
        AdministrationServiceProvider.getAdminService().addComponentInst(userId, component);
        return component.getId();
    }

    public String removeComponent(String userId, String componentId) throws AdminException {
        ComponentInst component;
        SpaceInst space = this.getPersonalSpace(userId);
        if (space != null && (component = this.getComponent(space, componentId)) != null) {
            AdministrationServiceProvider.getAdminService().deleteComponentInst(userId, componentId, true);
            return component.getName();
        }
        return null;
    }

    public SpaceInst getPersonalSpace(String userId) {
        try {
            return AdministrationServiceProvider.getAdminService().getPersonalSpace(userId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)((Object)e));
            return null;
        }
    }

    private ComponentInst getComponent(SpaceInst space, String componentId) {
        List<ComponentInst> components = space.getAllComponentsInst();
        for (ComponentInst component : components) {
            if (!component.getId().equalsIgnoreCase(componentId)) continue;
            return component;
        }
        return null;
    }

    private LocalizationBundle getMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_LOCATION, (String)language);
    }
}

