/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.SystemWrapper;

@Service
@Singleton
public class PersonalComponentRegistry
implements Initialization {
    private static final int MAX_DEPTH = 2;
    private final Map<String, PersonalComponent> componentsByName = new HashMap<String, PersonalComponent>();

    PersonalComponentRegistry() {
    }

    private static Path getPersonalComponentDescriptorHome() {
        SystemWrapper system = SystemWrapper.getInstance();
        return Paths.get(system.getenv("SILVERPEAS_HOME"), "xmlcomponents", "personals");
    }

    private static PersonalComponent loadComponent(File descriptor) {
        PersonalComponent personalComponent;
        JAXBContext context = JAXBContext.newInstance((String)"org.silverpeas.core.admin.component.model");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FileInputStream in = new FileInputStream(descriptor);
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            personalComponent = (PersonalComponent)unmarshaller.unmarshal(factory.createXMLStreamReader(in), PersonalComponent.class).getValue();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException | XMLStreamException e) {
                throw new SilverpeasRuntimeException(e.getMessage(), e);
            }
        }
        ((InputStream)in).close();
        return personalComponent;
    }

    public static PersonalComponentRegistry get() {
        return (PersonalComponentRegistry)ServiceProvider.getService(PersonalComponentRegistry.class, (Annotation[])new Annotation[0]);
    }

    public void init() {
        Path descriptorHome = PersonalComponentRegistry.getPersonalComponentDescriptorHome();
        try (Stream<Path> paths = Files.find(descriptorHome, 2, (p, a2) -> p.toFile().isFile() && "xml".equalsIgnoreCase(FilenameUtils.getExtension((String)p.toString())), new FileVisitOption[0]);){
            paths.forEach(p -> {
                PersonalComponent component = PersonalComponentRegistry.loadComponent(p.toFile());
                this.componentsByName.put(component.getName(), component);
            });
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public Optional<PersonalComponent> getPersonalComponent(String componentName) {
        return Optional.ofNullable(this.componentsByName.get(componentName));
    }

    public Map<String, PersonalComponent> getAllPersonalComponents() {
        return Collections.unmodifiableMap(this.componentsByName);
    }
}

