/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.cache.service;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.silverpeas.kernel.cache.model.ExternalCache;
import org.silverpeas.kernel.cache.service.CacheAccessor;
import org.silverpeas.kernel.cache.service.InMemoryCache;

public class ApplicationCacheAccessor
implements CacheAccessor<ExternalCache> {
    private static final ApplicationCacheAccessor instance = new ApplicationCacheAccessor();
    private final ExternalCache cache = ServiceLoader.load(ExternalCache.class).findFirst().orElseGet(() -> new DefaultCache());

    public static ApplicationCacheAccessor getInstance() {
        return instance;
    }

    ApplicationCacheAccessor() {
    }

    @Override
    public ExternalCache getCache() {
        return this.cache;
    }

    private static class DefaultCache
    extends ExternalCache {
        private final InMemoryCache cache = new InMemoryCache();

        private DefaultCache() {
        }

        @Override
        public void put(Object key, Object value, int timeToLive, int timeToIdle) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T computeIfAbsent(Object key, Class<T> classType, int timeToLive, int timeToIdle, Supplier<T> valueSupplier) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String add(Object value) {
            return this.cache.add(value);
        }

        @Override
        public void put(Object key, Object value) {
            this.cache.put(key, value);
        }

        @Override
        public <T> T computeIfAbsent(Object key, Class<T> classType, Supplier<T> valueSupplier) {
            return this.cache.computeIfAbsent(key, classType, valueSupplier);
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public Object get(Object key) {
            return this.cache.get(key);
        }

        @Override
        public Object remove(Object key) {
            return this.cache.remove(key);
        }

        @Override
        public <T> T remove(Object key, Class<T> classType) {
            return this.cache.remove(key, classType);
        }

        @Override
        public Map<Object, Object> getAll() {
            return this.cache.getAll();
        }
    }
}

