/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.security.Principal;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.security.AccessContext;

public class SilverpeasUserPrincipal
implements Principal {
    private final User user;
    private final AccessContext context;

    public SilverpeasUserPrincipal(@Nonnull User user) {
        Objects.requireNonNull(user);
        this.user = user;
        this.context = AccessContext.EMPTY;
    }

    public SilverpeasUserPrincipal(@Nonnull User user, AccessContext context) {
        Objects.requireNonNull(user);
        this.user = user;
        this.context = context;
    }

    @Override
    public String getName() {
        return this.user.getId();
    }

    public User getUser() {
        return this.user;
    }

    public AccessContext getAccessContext() {
        return this.context;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SilverpeasUserPrincipal that = (SilverpeasUserPrincipal)o;
        return Objects.equals(this.user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.user);
    }

    public boolean isSystem() {
        return this.user.isSystem();
    }
}

