/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.security.AccessContext;
import org.silverpeas.core.jcr.security.SilverpeasUserPrincipal;

public abstract class SilverpeasJCRLoginModule
extends AbstractLoginModule {
    private Credentials userId = null;
    private Principal principal = null;
    private boolean success = false;
    private boolean initialized = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.initialized = true;
    }

    public boolean login() throws LoginException {
        try {
            Credentials credentials = this.getCredentials();
            this.success = false;
            if (this.isCredentialsSupported(credentials)) {
                User user = this.authenticateUser(credentials);
                AccessContext context = this.getAccessContext(credentials);
                this.principal = new SilverpeasUserPrincipal(user, context);
                this.success = true;
            }
            return this.success;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    public boolean commit() {
        if (!this.success) {
            this.clearState();
            return false;
        }
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().add(this.principal);
            this.userId = new SimpleCredentials(this.principal.getName(), new char[0]);
            this.subject.getPublicCredentials().add(this.userId);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        Set<Object> userCredentials = this.getAllCredentials();
        Set<Principal> userPrincipals = this.getAllPrincipals();
        return this.logout(userCredentials.isEmpty() ? null : userCredentials, userPrincipals.isEmpty() ? null : userPrincipals);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void clearState() {
        super.clearState();
        this.userId = null;
        this.principal = null;
    }

    protected Set<Object> getAllCredentials() {
        return Stream.of(this.userId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected Set<Principal> getAllPrincipals() {
        return Stream.of(this.principal).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected abstract User authenticateUser(Credentials var1) throws LoginException;

    @Nonnull
    protected AccessContext getAccessContext(Credentials credentials) {
        return AccessContext.EMPTY;
    }

    private boolean isCredentialsSupported(Credentials credentials) {
        return this.getSupportedCredentials().stream().anyMatch(c -> c.isInstance(credentials));
    }
}

