/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hwp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.util.LittleEndian;

public class HwpStreamReader {
    private InputStream input;
    private byte[] buf;

    public HwpStreamReader(InputStream inputStream) {
        this.input = inputStream;
        this.buf = new byte[4];
    }

    public short uint8() throws IOException {
        IOUtils.readFully((InputStream)this.input, (byte[])this.buf, (int)0, (int)1);
        return LittleEndian.getUByte((byte[])this.buf);
    }

    public int uint16() throws IOException {
        IOUtils.readFully((InputStream)this.input, (byte[])this.buf, (int)0, (int)2);
        return LittleEndian.getUShort((byte[])this.buf);
    }

    public int[] uint16(int i) throws IOException {
        if (i <= 0) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[i * 2];
        IOUtils.readFully((InputStream)this.input, (byte[])buf, (int)0, (int)(i * 2));
        int[] uints = new int[i];
        for (int ii = 0; ii < i; ++ii) {
            uints[ii] = LittleEndian.getUShort((byte[])buf, (int)(ii * 2));
        }
        return uints;
    }

    public long uint32() throws IOException {
        int read = org.apache.poi.util.IOUtils.readFully((InputStream)this.input, (byte[])this.buf, (int)0, (int)4);
        if (read == -1) {
            return -1L;
        }
        if (read < 4) {
            throw new EOFException();
        }
        return LittleEndian.getUInt((byte[])this.buf);
    }

    public void skipFully(long toSkip) throws IOException {
        IOUtils.skipFully((InputStream)this.input, (long)toSkip);
    }
}

