/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service.caching.impl;

import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.service.ServiceAdapter;
import com.sun.portal.container.service.caching.ClientCachingService;
import com.sun.portal.container.service.caching.ResourceCacheEntry;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCachingServiceImpl
extends ServiceAdapter
implements ClientCachingService {
    private static final String DESCRIPTION = "Enables caching on the browser by setting the appropriate headers of the HTTP Response";
    private static final String CACHED_RESOURCES = "javax.portlet.cached_resources";
    private static final int TIME_PRODUCT = 1000;

    @Override
    public void updateResourceCache(ContainerRequest containerRequest, ContainerResponse containerResponse, ResourceCacheEntry resourceCacheEntry, boolean isPublic) {
        ConcurrentMap<String, ResourceCacheEntry> resources = null;
        resources = isPublic ? this.getPublicResourceMap(containerRequest) : this.getPrivateResourceMap(containerRequest);
        HttpServletRequest request = containerRequest.getHttpServletRequest();
        String resourceURI = request.getRequestURI();
        resources.put(resourceURI, resourceCacheEntry);
        HttpServletResponse response = containerResponse.getHttpServletResponse();
        this.updateResponseHeaders(resourceCacheEntry, response);
    }

    @Override
    public boolean hasResourceCacheExpired(ContainerRequest containerRequest, ContainerResponse containerResponse) {
        HttpServletRequest request = containerRequest.getHttpServletRequest();
        long now = Calendar.getInstance().getTimeInMillis();
        long header = request.getDateHeader("If-Modified-Since");
        String eTag = request.getHeader("If-None-Match");
        if (header > 0L) {
            if (header > now) {
                HttpServletResponse response = containerResponse.getHttpServletResponse();
                this.updateResponseHeaders(this.getCachedResource(containerRequest), response);
                response.setStatus(304);
                return false;
            }
            if (eTag == null) {
                this.removeCachedResource(containerRequest);
            }
            return true;
        }
        this.removeCachedResource(containerRequest);
        return true;
    }

    @Override
    public ResourceCacheEntry getCachedResource(ContainerRequest containerRequest) {
        String uri = containerRequest.getHttpServletRequest().getRequestURI();
        ConcurrentMap<String, ResourceCacheEntry> resources = this.getPublicResourceMap(containerRequest);
        if (resources.containsKey(uri)) {
            return (ResourceCacheEntry)resources.get(uri);
        }
        return (ResourceCacheEntry)this.getPrivateResourceMap(containerRequest).get(uri);
    }

    @Override
    public void removeCachedResource(ContainerRequest containerRequest) {
        String uri;
        ConcurrentMap<String, ResourceCacheEntry> resources = this.getPublicResourceMap(containerRequest);
        if (resources.containsKey(uri = containerRequest.getHttpServletRequest().getRequestURI())) {
            resources.remove(uri);
        } else {
            this.getPrivateResourceMap(containerRequest).remove(uri);
        }
    }

    @Override
    public String getName() {
        return "com.sun.portal.container.service.ClientCachingService";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    private ConcurrentMap<String, ResourceCacheEntry> getPrivateResourceMap(ContainerRequest containerRequest) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        ConcurrentHashMap cachedResources = (ConcurrentHashMap)portletWindowContext.getProperty(CACHED_RESOURCES);
        if (cachedResources == null) {
            cachedResources = new ConcurrentHashMap();
            portletWindowContext.setProperty(CACHED_RESOURCES, cachedResources);
        }
        return cachedResources;
    }

    private ConcurrentMap<String, ResourceCacheEntry> getPublicResourceMap(ContainerRequest containerRequest) {
        ServletContext context = this.getServletContext();
        ConcurrentHashMap cachedResources = (ConcurrentHashMap)context.getAttribute(CACHED_RESOURCES);
        if (cachedResources == null) {
            cachedResources = new ConcurrentHashMap();
            context.setAttribute(CACHED_RESOURCES, cachedResources);
        }
        return cachedResources;
    }

    @Override
    public void updateAndReuseResourceCache(ContainerRequest containerRequest, ContainerResponse containerResponse, ResourceCacheEntry resourceCacheEntry, boolean isPublic) {
        this.updateResourceCache(containerRequest, containerResponse, resourceCacheEntry, isPublic);
        HttpServletResponse response = containerResponse.getHttpServletResponse();
        response.setStatus(304);
    }

    private void updateResponseHeaders(ResourceCacheEntry resourceCacheEntry, HttpServletResponse response) {
        int expirationTime = resourceCacheEntry.getExpirationTime();
        String eTag = resourceCacheEntry.getETag();
        long now = Calendar.getInstance().getTimeInMillis();
        if (response.containsHeader("Cache-Control")) {
            response.setHeader("Cache-Control", "public, max-age=" + expirationTime + ", must-revalidate");
        } else {
            response.addHeader("Cache-Control", "public, max-age=" + expirationTime + ", must-revalidate");
        }
        if (response.containsHeader("Expires")) {
            response.setDateHeader("Expires", now + (long)(expirationTime * 1000));
        } else {
            response.addDateHeader("Expires", now + (long)(expirationTime * 1000));
        }
        if (response.containsHeader("Last-Modified")) {
            response.setDateHeader("Last-Modified", now + (long)(expirationTime * 1000));
        } else {
            response.addDateHeader("Last-Modified", now + (long)(expirationTime * 1000));
        }
        if (response.containsHeader("Pragma")) {
            response.setHeader("Pragma", null);
        }
        if (eTag != null) {
            response.addHeader("ETag", eTag);
        }
    }
}

