/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.tools;

import java.io.ByteArrayInputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.sourceforge.jcetaglib.lib.CertTools;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;

public class KeyTools {
    private static byte[] salt = new byte[]{35, -56, -103, -116, -60, -1, -18, 125};
    private static int count = 100;
    private static String alg = "1.2.840.113549.1.12.1.3";

    private KeyTools() {
    }

    public static KeyStore createP12(String alias, PrivateKey privKey, X509Certificate cert, X509Certificate cacert) throws Exception {
        Certificate[] chain = cacert == null ? null : new Certificate[]{cacert};
        return KeyTools.createP12(alias, privKey, cert, chain);
    }

    public static KeyStore createP12(String alias, PrivateKey privKey, X509Certificate cert, Certificate[] cachain) throws Exception {
        int i;
        if (cert == null) {
            throw new IllegalArgumentException("Parameter cert cannot be null.");
        }
        int len = 1;
        if (cachain != null) {
            len += cachain.length;
        }
        Certificate[] chain = new Certificate[len];
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        chain[0] = cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        if (cachain != null) {
            for (i = 0; i < cachain.length; ++i) {
                X509Certificate tmpcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cachain[i].getEncoded()));
                chain[i + 1] = tmpcert;
            }
        }
        if (chain.length > 1) {
            for (i = 1; i < chain.length; ++i) {
                X509Certificate cacert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(chain[i].getEncoded()));
                PKCS12BagAttributeCarrier caBagAttr = (PKCS12BagAttributeCarrier)chain[i];
                String cafriendly = CertTools.getPartFromDN(((Object)cacert.getSubjectDN()).toString(), "CN");
                caBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString(cafriendly));
            }
        }
        PKCS12BagAttributeCarrier certBagAttr = (PKCS12BagAttributeCarrier)chain[0];
        certBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString(alias));
        certBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (DEREncodable)CertTools.createSubjectKeyId(chain[0].getPublicKey()));
        KeyFactory keyfact = KeyFactory.getInstance(privKey.getAlgorithm(), "BC");
        PrivateKey pk = keyfact.generatePrivate(new PKCS8EncodedKeySpec(privKey.getEncoded()));
        PKCS12BagAttributeCarrier keyBagAttr = (PKCS12BagAttributeCarrier)pk;
        keyBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString(alias));
        keyBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (DEREncodable)CertTools.createSubjectKeyId(chain[0].getPublicKey()));
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        store.load(null, null);
        store.setKeyEntry(alias, pk, null, chain);
        return store;
    }

    public static Certificate[] getCertChain(KeyStore keyStore, String privateKeyAlias) throws KeyStoreException {
        Certificate[] certchain = keyStore.getCertificateChain(privateKeyAlias);
        if (certchain.length < 1) {
            System.out.println("Cannot load certificate chain with alias '" + privateKeyAlias + "' from keystore.");
            return certchain;
        }
        if (certchain.length > 0 && CertTools.isSelfSigned((X509Certificate)certchain[certchain.length - 1])) {
            return certchain;
        }
        ArrayList<Certificate> array = new ArrayList<Certificate>();
        for (int i = 0; i < certchain.length; ++i) {
            array.add(certchain[i]);
        }
        boolean stop = false;
        while (!stop) {
            X509Certificate cert = (X509Certificate)array.get(array.size() - 1);
            String ialias = CertTools.getPartFromDN(((Object)cert.getIssuerDN()).toString(), "CN");
            Certificate[] chain1 = keyStore.getCertificateChain(ialias);
            if (chain1 == null) {
                stop = true;
                continue;
            }
            if (chain1.length == 0) {
                System.out.println("No RootCA certificate found!");
                stop = true;
            }
            for (int j = 0; j < chain1.length; ++j) {
                array.add(chain1[j]);
                if (!CertTools.isSelfSigned((X509Certificate)chain1[j])) continue;
                stop = true;
            }
        }
        Certificate[] ret = new Certificate[array.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (X509Certificate)array.get(i);
        }
        return ret;
    }

    public static PrivateKey decryptPrivateKey(byte[] wrappedKey, String password) throws Exception {
        PBEParameterSpec defParams = new PBEParameterSpec(salt, count);
        AlgorithmParameters params = AlgorithmParameters.getInstance(alg, "BC");
        params.init(defParams);
        EncryptedPrivateKeyInfo privKeyInfo = new EncryptedPrivateKeyInfo(params, wrappedKey);
        PBEKeySpec pbeSpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg, "BC");
        Cipher cipher = Cipher.getInstance(alg, "BC");
        cipher.init(2, (Key)keyFact.generateSecret(pbeSpec), privKeyInfo.getAlgParameters());
        PKCS8EncodedKeySpec keySpec = privKeyInfo.getKeySpec(cipher);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }
}

