/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.lib.Keystore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Macs {
    private static int BUFFERSIZE_TEXT = 64;
    private static int BUFFERSIZE_FILE = 8192;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer generateMAC(StringBuffer text, String keyfile, StringBuffer passphrase, String algorithm, String macname) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Macs.generateMAC(new ByteArrayInputStream(text.toString().getBytes()), dao, keyfile, passphrase, algorithm, macname, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var9_9 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static StringBuffer generateFileMAC(String file, String keyfile, StringBuffer passphrase, String algorithm, String macname) throws CryptoException {
        IOException e22;
        StringBuffer stringBuffer;
        FilterOutputStream dao;
        FileInputStream fis;
        block12: {
            fis = null;
            ByteArrayOutputStream bao = null;
            dao = null;
            fis = new FileInputStream(file);
            bao = new ByteArrayOutputStream();
            dao = new DataOutputStream(bao);
            Macs.generateMAC(fis, (DataOutputStream)dao, keyfile, passphrase, algorithm, macname, BUFFERSIZE_FILE);
            stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
            Object var10_10 = null;
            if (dao == null) break block12;
            try {
                dao.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        return stringBuffer;
        catch (IOException ioe) {
            try {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
            catch (Throwable throwable) {
                block14: {
                    IOException e22;
                    Object var10_11 = null;
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block14;
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {}
                }
                throw throwable;
            }
        }
    }

    public static void generateMAC(InputStream is, DataOutputStream daos, String keyfile, StringBuffer passphrase, String algorithm, String macname, int bufferlength) throws CryptoException, IOException {
        Key secretKey = null;
        Mac mac = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            secretKey = Keystore.loadKey(algorithm, keyfile, passphrase);
            mac = Mac.getInstance(macname, "BC");
            mac.init(secretKey);
            byte[] buffer = new byte[bufferlength];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                mac.update(buffer, 0, length);
            }
            byte[] result = mac.doFinal();
            daos.write(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }
}

