/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.sourceforge.jcetaglib.exceptions.KeystoreException;
import net.sourceforge.jcetaglib.lib.Clean;
import net.sourceforge.jcetaglib.lib.Seed;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Keystore {
    static final String SECRET_KEYSTORE_ALGORITHM = "PBEWithSHAAndTwofish-CBC";
    static final int SECRET_KEYSTORE_COUNT = 100;

    /*
     * Loose catch block
     */
    public static void generateKey(String algorithm, int strength, byte[] seed, String file, StringBuffer passphrase) throws KeystoreException {
        SecretKey pbeKey;
        SecretKey key;
        block8: {
            KeyGenerator kg = null;
            FileOutputStream fos = null;
            Security.addProvider((Provider)new BouncyCastleProvider());
            SecureRandom sr = Seed.getSecureRandom(seed);
            kg = KeyGenerator.getInstance(algorithm, "BC");
            kg.init(strength, sr);
            key = kg.generateKey();
            byte[] randomsalt = new byte[8];
            sr.nextBytes(randomsalt);
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(randomsalt, 100);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toString().toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(SECRET_KEYSTORE_ALGORITHM);
            pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(SECRET_KEYSTORE_ALGORITHM);
            pbeCipher.init(3, (Key)pbeKey, pbeParamSpec);
            byte[] wrappedKey = pbeCipher.wrap(key);
            fos = new FileOutputStream(file);
            fos.write(randomsalt);
            fos.write(wrappedKey);
            Object var17_19 = null;
            if (fos == null) break block8;
            try {
                fos.close();
                break block8;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
                break block8;
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new KeystoreException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                Object key2 = null;
                Object pbeKey2 = null;
                Clean.blank(passphrase);
                passphrase = null;
                throw throwable;
            }
        }
        key = null;
        pbeKey = null;
        Clean.blank(passphrase);
        passphrase = null;
    }

    /*
     * Loose catch block
     */
    public static Key loadKey(String algorithm, String file, StringBuffer passphrase) throws KeystoreException {
        IOException ioe22;
        Key key;
        SecretKey pbeKey;
        ByteArrayOutputStream baos;
        FileInputStream fInput;
        block14: {
            Key newkey;
            fInput = null;
            baos = null;
            Security.addProvider((Provider)new BouncyCastleProvider());
            fInput = new FileInputStream(file);
            byte[] randomsalt = new byte[8];
            fInput.read(randomsalt);
            baos = new ByteArrayOutputStream();
            int i = 0;
            while ((i = fInput.read()) != -1) {
                baos.write(i);
            }
            byte[] wrappedKey = baos.toByteArray();
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(randomsalt, 100);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toString().toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(SECRET_KEYSTORE_ALGORITHM);
            pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(SECRET_KEYSTORE_ALGORITHM);
            pbeCipher.init(4, (Key)pbeKey, pbeParamSpec);
            key = newkey = pbeCipher.unwrap(wrappedKey, algorithm, 3);
            Object var16_17 = null;
            if (fInput == null) break block14;
            try {
                fInput.close();
            }
            catch (IOException ioe22) {
                // empty catch block
            }
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException ioe22) {
                // empty catch block
            }
        }
        pbeKey = null;
        Clean.blank(passphrase);
        passphrase = null;
        return key;
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw new KeystoreException(ex.getMessage());
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var16_18 = null;
                if (fInput != null) {
                    try {
                        fInput.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                Object pbeKey2 = null;
                Clean.blank(passphrase);
                passphrase = null;
                throw throwable;
            }
        }
    }
}

