/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.StringTokenizer;
import net.sourceforge.jcetaglib.tools.Hex;
import net.sourceforge.jcetaglib.tools.KeyTools;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Base64;

public class CertTools {
    public static String getPartFromDN(String dn, String dnpart) {
        String trimmeddn = dn.trim();
        String part = null;
        String o = null;
        StringTokenizer st = new StringTokenizer(trimmeddn, ",=");
        while (st.hasMoreTokens()) {
            o = st.nextToken();
            if (!o.trim().equalsIgnoreCase(dnpart)) continue;
            part = st.nextToken();
        }
        return part;
    }

    public static PrivateKey getPrivatefromPEM(String keyFile, String keypwd) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, Exception {
        FileInputStream inStrm = new FileInputStream(keyFile);
        PrivateKey privKey = CertTools.getPrivatefromPEM(inStrm, keypwd);
        return privKey;
    }

    public static PrivateKey getPrivatefromPEM(InputStream keystream, String keypwd) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, Exception {
        String temp;
        String endKey;
        String beginKey;
        if (keypwd == null || keypwd == "") {
            beginKey = "-----BEGIN PRIVATE KEY-----";
            endKey = "-----END PRIVATE KEY-----";
        } else {
            beginKey = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
            endKey = "-----END ENCRYPTED PRIVATE KEY-----";
        }
        BufferedReader bufRdr = new BufferedReader(new InputStreamReader(keystream));
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        PrintStream opstr = new PrintStream(ostr);
        while ((temp = bufRdr.readLine()) != null && !temp.equals(beginKey)) {
        }
        if (temp == null) {
            throw new IOException("Error in " + keystream.toString() + ", missing " + beginKey + " boundary");
        }
        while ((temp = bufRdr.readLine()) != null && !temp.equals(endKey)) {
            opstr.print(temp);
        }
        if (temp == null) {
            throw new IOException("Error in " + keystream.toString() + ", missing " + endKey + " boundary");
        }
        opstr.close();
        byte[] keybuf = Base64.decode((byte[])ostr.toByteArray());
        PrivateKey privKey = null;
        PKCS8EncodedKeySpec prvSpec = new PKCS8EncodedKeySpec(keybuf);
        if (keypwd == null || keypwd == "") {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            privKey = kf.generatePrivate(prvSpec);
        } else {
            privKey = KeyTools.decryptPrivateKey(keybuf, keypwd);
        }
        return privKey;
    }

    public static X509Certificate getCertfromPEM(String certFile) throws IOException, CertificateException {
        FileInputStream inStrm = new FileInputStream(certFile);
        X509Certificate cert = CertTools.getCertfromPEM(inStrm);
        return cert;
    }

    public static X509Certificate getCertfromPEM(InputStream certstream) throws IOException, CertificateException {
        String temp;
        String beginKey = "-----BEGIN CERTIFICATE-----";
        String endKey = "-----END CERTIFICATE-----";
        BufferedReader bufRdr = new BufferedReader(new InputStreamReader(certstream));
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        PrintStream opstr = new PrintStream(ostr);
        while ((temp = bufRdr.readLine()) != null && !temp.equals(beginKey)) {
        }
        if (temp == null) {
            throw new IOException("Error in " + certstream.toString() + ", missing " + beginKey + " boundary");
        }
        while ((temp = bufRdr.readLine()) != null && !temp.equals(endKey)) {
            opstr.print(temp);
        }
        if (temp == null) {
            throw new IOException("Error in " + certstream.toString() + ", missing " + endKey + " boundary");
        }
        opstr.close();
        byte[] certbuf = Base64.decode((byte[])ostr.toByteArray());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate x509cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certbuf));
        return x509cert;
    }

    public static X509CRL getCRLfromByteArray(byte[] crl) throws CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509CRL x509crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crl));
        return x509crl;
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        boolean ret = ((Object)cert.getSubjectDN()).equals(cert.getIssuerDN());
        return ret;
    }

    public static SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(pubKey.getEncoded());
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream((InputStream)bIn).readObject());
            return new SubjectKeyIdentifier(info);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating key");
        }
    }

    public static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey pubKey) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(pubKey.getEncoded());
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream((InputStream)bIn).readObject());
            return new AuthorityKeyIdentifier(info);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating AuthorityKeyId");
        }
    }

    public static String getFingerprintAsString(X509Certificate cert) {
        try {
            byte[] res = CertTools.generateSHA1Fingerprint(cert.getEncoded());
            return Hex.encode(res);
        }
        catch (CertificateEncodingException cee) {
            System.out.println("Error encoding X509 certificate." + cee);
            return null;
        }
    }

    public static byte[] generateSHA1Fingerprint(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            System.out.println("SHA1 algorithm not supported" + nsae);
            return null;
        }
    }
}

