/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.segment.standby.server.AddressResolver;
import org.apache.jackrabbit.oak.segment.standby.server.ClientFilter;
import org.apache.jackrabbit.oak.segment.standby.server.InetAddressResolver;

class ClientIpFilter
implements ClientFilter {
    private static final Pattern LETTERS = Pattern.compile("[a-zA-Z]+");
    private final String[] allowedIpRanges;
    private final AddressResolver addressResolver;

    private static boolean containsLetters(String s) {
        return LETTERS.matcher(s).matches();
    }

    private static boolean areAddressesEqual(InetAddress a, InetAddress b) {
        return Arrays.equals(a.getAddress(), b.getAddress());
    }

    private static int compare(byte[] left, byte[] right) {
        assert (left.length == right.length);
        for (int i = 0; i < left.length; ++i) {
            int l = left[i] & 0xFF;
            int r = right[i] & 0xFF;
            if (l < r) {
                return -1;
            }
            if (r >= l) continue;
            return 1;
        }
        return 0;
    }

    private static boolean isAddressInRange(InetAddress address, InetAddress left, InetAddress right) {
        byte[] addressBytes = address.getAddress();
        byte[] leftBytes = left.getAddress();
        if (leftBytes.length != addressBytes.length) {
            return false;
        }
        byte[] rightBytes = right.getAddress();
        if (rightBytes.length != addressBytes.length) {
            return false;
        }
        return ClientIpFilter.compare(leftBytes, addressBytes) <= 0 && ClientIpFilter.compare(addressBytes, rightBytes) <= 0;
    }

    private static boolean isAllowed(InetAddress client, AddressResolver addressResolver, String left, String right) {
        InetAddress leftAddress = addressResolver.resolve(left);
        InetAddress rightAddress = addressResolver.resolve(right);
        if (leftAddress == null || rightAddress == null) {
            return false;
        }
        return ClientIpFilter.isAddressInRange(client, leftAddress, rightAddress);
    }

    private static boolean isAllowed(InetAddress client, AddressResolver addressResolver, String match) {
        InetAddress matchAddress = addressResolver.resolve(match);
        if (matchAddress == null) {
            return false;
        }
        return ClientIpFilter.areAddressesEqual(matchAddress, client);
    }

    ClientIpFilter(String[] filters) {
        this(filters, new InetAddressResolver());
    }

    ClientIpFilter(String[] filters, AddressResolver addressResolver) {
        this.allowedIpRanges = filters;
        this.addressResolver = addressResolver;
    }

    @Override
    public boolean isAllowed(SocketAddress address) {
        return this.isAllowed(((InetSocketAddress)address).getAddress());
    }

    private boolean isAllowed(InetAddress address) {
        if (this.allowedIpRanges == null) {
            return true;
        }
        if (this.allowedIpRanges.length == 0) {
            return true;
        }
        for (String s : this.allowedIpRanges) {
            String[] parts = s.split("-");
            if (!(parts.length == 2 && !ClientIpFilter.containsLetters(parts[0]) && !ClientIpFilter.containsLetters(parts[1]) ? ClientIpFilter.isAllowed(address, this.addressResolver, parts[0].trim(), parts[1].trim()) : ClientIpFilter.isAllowed(address, this.addressResolver, s.trim()))) continue;
            return true;
        }
        return false;
    }
}

