/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.CachingSegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingArchiveManager
implements SegmentArchiveManager {
    private final SegmentArchiveManager delegate;
    private final PersistentCache persistentCache;

    public CachingArchiveManager(PersistentCache persistentCache, SegmentArchiveManager delegate) {
        this.delegate = delegate;
        this.persistentCache = persistentCache;
    }

    @Override
    @NotNull
    public List<String> listArchives() throws IOException {
        return this.delegate.listArchives();
    }

    @Override
    @Nullable
    public SegmentArchiveReader open(@NotNull String archiveName) throws IOException {
        SegmentArchiveReader delegateArchiveReader = this.delegate.open(archiveName);
        if (delegateArchiveReader != null) {
            return new CachingSegmentArchiveReader(this.persistentCache, delegateArchiveReader);
        }
        return null;
    }

    @Override
    @Nullable
    public SegmentArchiveReader forceOpen(String archiveName) throws IOException {
        SegmentArchiveReader delegateArchiveReader = this.delegate.forceOpen(archiveName);
        if (delegateArchiveReader != null) {
            return new CachingSegmentArchiveReader(this.persistentCache, delegateArchiveReader);
        }
        return null;
    }

    @Override
    @NotNull
    public SegmentArchiveWriter create(@NotNull String archiveName) throws IOException {
        return this.delegate.create(archiveName);
    }

    @Override
    public boolean delete(@NotNull String archiveName) {
        return this.delegate.delete(archiveName);
    }

    @Override
    public boolean renameTo(@NotNull String from, @NotNull String to) {
        return this.delegate.renameTo(from, to);
    }

    @Override
    public void copyFile(@NotNull String from, @NotNull String to) throws IOException {
        this.delegate.copyFile(from, to);
    }

    @Override
    public boolean exists(@NotNull String archiveName) {
        return this.delegate.exists(archiveName);
    }

    @Override
    public void recoverEntries(@NotNull String archiveName, @NotNull LinkedHashMap<UUID, byte[]> entries) throws IOException {
        this.delegate.recoverEntries(archiveName, entries);
    }

    @Override
    public void backup(@NotNull String archiveName, @NotNull String backupArchiveName, @NotNull Set<UUID> recoveredEntries) throws IOException {
        this.delegate.backup(archiveName, backupArchiveName, recoveredEntries);
    }
}

