/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.CompactorUtils;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.CompactionWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassicCompactor
extends Compactor {
    static final int UPDATE_LIMIT = Integer.getInteger("compaction.update.limit", 10000);
    @NotNull
    private final CompactionWriter writer;
    @NotNull
    private final GCNodeWriteMonitor compactionMonitor;

    public ClassicCompactor(@NotNull CompactionWriter writer, @NotNull GCNodeWriteMonitor compactionMonitor) {
        this.writer = Objects.requireNonNull(writer);
        this.compactionMonitor = Objects.requireNonNull(compactionMonitor);
    }

    @Override
    @Nullable
    public CompactedNodeState compactDown(@NotNull NodeState before, @NotNull NodeState after, @NotNull Canceller hardCanceller, @NotNull Canceller softCanceller) throws IOException {
        return this.compact(before, after, after, hardCanceller, softCanceller);
    }

    @Override
    @Nullable
    public CompactedNodeState compact(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller canceller) throws IOException {
        return this.compact(before, after, onto, canceller, Canceller.newCanceller());
    }

    @Nullable
    private CompactedNodeState compact(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller hardCanceller, @NotNull Canceller softCanceller) throws IOException {
        CompactedNodeState compactedState = this.getPreviouslyCompactedState(after);
        if (compactedState == null) {
            compactedState = new CompactDiff(onto, hardCanceller, softCanceller).diff(before, after);
        }
        return compactedState;
    }

    @Nullable
    protected CompactedNodeState writeNodeState(@NotNull NodeState nodeState, @Nullable Buffer stableIdBytes, boolean complete) throws IOException {
        if (complete) {
            CompactedNodeState.FullyCompactedNodeState compacted = this.writer.writeFullyCompactedNode(nodeState, stableIdBytes);
            this.compactionMonitor.onNode();
            return compacted;
        }
        return this.writer.writePartiallyCompactedNode(nodeState, stableIdBytes);
    }

    @Nullable
    protected CompactedNodeState getPreviouslyCompactedState(NodeState nodeState) {
        return this.writer.getPreviouslyCompactedState(nodeState);
    }

    @NotNull
    protected PropertyState compact(@NotNull PropertyState property) {
        this.compactionMonitor.onProperty();
        String name = property.getName();
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.compactionMonitor.onBinary();
            return BinaryPropertyState.binaryProperty((String)name, (Blob)((Blob)property.getValue(Type.BINARY)));
        }
        if (type == Type.BINARIES) {
            ArrayList<Blob> blobs = new ArrayList<Blob>();
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.compactionMonitor.onBinary();
                blobs.add(blob);
            }
            return MultiBinaryPropertyState.binaryPropertyFromBlob((String)name, blobs);
        }
        return PropertyStates.createProperty((String)name, (Object)property.getValue(type), (Type)type);
    }

    private class CompactDiff
    implements NodeStateDiff {
        @NotNull
        private final NodeState base;
        @NotNull
        private final Canceller hardCanceller;
        @NotNull
        private final Canceller softCanceller;
        @NotNull
        private final List<PropertyState> modifiedProperties = new ArrayList<PropertyState>();
        @NotNull
        private NodeBuilder builder;
        @Nullable
        private IOException exception;
        private long modCount;

        private void updated() throws IOException {
            if (++this.modCount % (long)UPDATE_LIMIT == 0L) {
                CompactedNodeState newBase = ClassicCompactor.this.writeNodeState(this.builder.getNodeState(), null, false);
                Objects.requireNonNull(newBase);
                this.builder = new MemoryNodeBuilder((NodeState)newBase);
            }
        }

        CompactDiff(@NotNull NodeState base, @NotNull Canceller hardCanceller, Canceller softCanceller) {
            this.base = Objects.requireNonNull(base);
            this.builder = new MemoryNodeBuilder(base);
            this.hardCanceller = Objects.requireNonNull(hardCanceller);
            this.softCanceller = Objects.requireNonNull(softCanceller);
        }

        @NotNull
        private CancelableDiff newCancelableDiff() {
            return new CancelableDiff(this, () -> this.softCanceller.check().isCancelled() || this.hardCanceller.check().isCancelled());
        }

        @Nullable
        CompactedNodeState diff(@NotNull NodeState before, @NotNull NodeState after) throws IOException {
            boolean success = after.compareAgainstBaseState(before, (NodeStateDiff)this.newCancelableDiff());
            if (this.exception != null) {
                throw new IOException(this.exception);
            }
            if (success) {
                this.modifiedProperties.forEach(property -> this.builder.setProperty(ClassicCompactor.this.compact((PropertyState)property)));
                NodeState nodeState = this.builder.getNodeState();
                Validate.checkState((this.modCount == 0L || nodeState instanceof ModifiedNodeState ? 1 : 0) != 0);
                return ClassicCompactor.this.writeNodeState(nodeState, CompactorUtils.getStableIdBytes(after), true);
            }
            if (this.hardCanceller.check().isCancelled()) {
                return null;
            }
            return ClassicCompactor.this.writeNodeState(this.builder.getNodeState(), CompactorUtils.getStableIdBytes(after), false);
        }

        public boolean propertyAdded(@NotNull PropertyState after) {
            this.modifiedProperties.add(after);
            return true;
        }

        public boolean propertyChanged(@NotNull PropertyState before, @NotNull PropertyState after) {
            this.modifiedProperties.add(after);
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            this.builder.removeProperty(before.getName());
            return true;
        }

        private boolean childNodeUpdated(@NotNull String name, @NotNull NodeState before, @NotNull NodeState after) {
            try {
                NodeState child = this.base.getChildNode(name);
                NodeState onto = child.exists() ? child : EmptyNodeState.EMPTY_NODE;
                CompactedNodeState compacted = ClassicCompactor.this.compact(before, after, onto, this.hardCanceller, this.softCanceller);
                if (compacted == null) {
                    return false;
                }
                this.updated();
                this.builder.setChildNode(name, (NodeState)compacted);
                return compacted.isComplete();
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }

        public boolean childNodeAdded(@NotNull String name, @NotNull NodeState after) {
            return this.childNodeUpdated(name, EmptyNodeState.EMPTY_NODE, after);
        }

        public boolean childNodeChanged(@NotNull String name, @NotNull NodeState before, @NotNull NodeState after) {
            return this.childNodeUpdated(name, before, after);
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            try {
                this.updated();
                this.builder.getChildNode(name).remove();
                return true;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }
    }
}

