/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.lang.annotation.Annotation;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.TaskManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.ResponseEvent;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.Participant;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.engine.AbstractRequest;
import org.silverpeas.core.workflow.engine.WorkflowHub;

class ResponseRequest
extends AbstractRequest {
    protected ResponseRequest() {
    }

    public static ResponseRequest get(ResponseEvent event) {
        ResponseRequest request = (ResponseRequest)ServiceProvider.getService(ResponseRequest.class, (Annotation[])new Annotation[0]);
        request.setEvent(event);
        return request;
    }

    public void process(AbstractRequestTask.ProcessContext context) throws InterruptedException {
        ResponseEvent event = (ResponseEvent)this.getEvent();
        UpdatableProcessInstance instance = (UpdatableProcessInstance)event.getProcessInstance();
        String id = instance.getInstanceId();
        UpdatableHistoryStep step = (UpdatableHistoryStep)Transaction.performInOne(() -> this.createHistoryNewStep(new AbstractRequest.HistoryStepDescriptor().withActionName("#response#").withProcessInstance(instance)));
        this.processProcessInstance(id, event, step);
    }

    @Override
    protected boolean processEvent(UpdatableProcessInstance instance, String stepId) throws WorkflowException {
        String answer;
        UpdatableHistoryStep step = (UpdatableHistoryStep)instance.getHistoryStep(stepId);
        instance.updateHistoryStep(step);
        ResponseEvent event = (ResponseEvent)this.getEvent();
        try {
            answer = (String)event.getDataRecord().getField("Content").getObjectValue();
        }
        catch (FormException fe) {
            throw new WorkflowException("WorkflowEngineThread.process", "workflowEngine.EXP_UNKNOWN_ITEM", (Exception)((Object)fe));
        }
        State state = instance.answerQuestion(answer, event.getQuestionId());
        instance.removeActiveState(event.getResolvedState());
        step.setActionStatus(ActionStatus.PROCESSED);
        instance.updateHistoryStep(step);
        Participant participant = instance.getParticipant(state.getName());
        TaskManager taskManager = WorkflowHub.getTaskManager();
        Task task = taskManager.createTask(participant, instance);
        taskManager.unAssignTask(task);
        instance.removeWorkingUser(participant.getUser(), state, participant.getUserRoleName());
        step.setActionStatus(ActionStatus.AFFECTATIONS_DONE);
        instance.updateHistoryStep(step);
        instance.unLock();
        return false;
    }
}

