/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.pdc.classification.ClassifyEngine;
import org.silverpeas.core.pdc.classification.ClassifyEngineException;
import org.silverpeas.core.pdc.classification.ObjectValuePair;
import org.silverpeas.core.pdc.classification.PertinentAxis;
import org.silverpeas.core.pdc.classification.PertinentValue;
import org.silverpeas.core.pdc.classification.Position;
import org.silverpeas.core.pdc.classification.Value;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.SearchContext;
import org.silverpeas.core.pdc.pdc.model.SearchCriteria;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.service.PdcClassifyManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.JoinStatement;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DefaultPdcClassifyManager
implements PdcClassifyManager,
ComponentInstanceDeletion {
    @Inject
    private ClassifyEngine classifyEngine;
    @Inject
    private ContentManagementEngine contentMgtEngine;

    protected DefaultPdcClassifyManager() {
    }

    @Override
    public int isPositionAlreadyExists(int silverObjectId, ClassifyPosition position) throws PdcException {
        try {
            return this.classifyEngine.isPositionAlreadyExists(silverObjectId, position);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public int addPosition(int silverObjectId, ClassifyPosition position, String sComponentId) throws PdcException {
        int n;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                this.classifyEngine.classifySilverObject(connection, silverObjectId, position);
                n = 0;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PdcException(e);
                }
            }
            connection.close();
        }
        return n;
    }

    @Override
    public int updatePosition(ClassifyPosition position) throws PdcException {
        try {
            this.classifyEngine.updateSilverObjectPosition(position);
            return 0;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public int updatePositions(List<Value> classifyValues, int silverObjectId) throws PdcException {
        try {
            this.classifyEngine.updateSilverObjectPositions(classifyValues, silverObjectId);
            return 0;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public void deletePosition(int nPositionId, String sComponentId) throws PdcException {
        try (Connection connection = DBUtil.openConnection();){
            this.classifyEngine.unclassifySilverObjectByPositionId(connection, nPositionId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<Position<Value>> getPositions(int silverObjectId, String sComponentId) throws PdcException {
        try {
            return this.classifyEngine.findPositionsBySilverOjectId(silverObjectId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public void registerAxis(Connection con, int axisId) throws PdcException {
        try {
            this.classifyEngine.registerAxis(con, axisId);
        }
        catch (ClassifyEngineException e) {
            throw new PdcException((Throwable)((Object)e));
        }
    }

    @Override
    public void unregisterAxis(Connection con, int axisId) throws PdcException {
        try {
            this.classifyEngine.unregisterAxis(con, axisId);
        }
        catch (ClassifyEngineException e) {
            throw new PdcException((Throwable)((Object)e));
        }
    }

    @Override
    public void createValuesAndReplace(Connection con, String axisId, List<String> oldPath, List<String> newPath) throws PdcException {
        Objects.requireNonNull(con);
        ArrayList<Value> oldValues = new ArrayList<Value>();
        ArrayList<Value> newValues = new ArrayList<Value>();
        int id = Integer.parseInt(axisId);
        for (int i = 0; i < oldPath.size(); ++i) {
            Value oldValue = new Value();
            Value newValue = new Value();
            String path = oldPath.get(i);
            oldValue.setAxisId(id);
            oldValue.setValue(path);
            path = newPath.get(i);
            newValue.setAxisId(id);
            newValue.setValue(path);
            oldValues.add(oldValue);
            newValues.add(newValue);
        }
        try {
            Position position = new Position(newValues);
            if (this.classifyEngine.isPositionAlreadyExists(id, position) == -1) {
                this.classifyEngine.replaceValuesOnAxis(con, oldValues, newValues);
            }
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<Integer> getObjectsByInstance(String instanceId) throws PdcException {
        List<Integer> objectIdList;
        try {
            JoinStatement contentJoin = this.contentMgtEngine.getPositionsByGenericSearch(null, null, null);
            ArrayList criterias = new ArrayList();
            ArrayList<String> instanceIds = new ArrayList<String>();
            instanceIds.add(instanceId);
            objectIdList = this.classifyEngine.findSilverOjectByCriterias(criterias, instanceIds, contentJoin, null, null, true, false);
        }
        catch (ClassifyEngineException e) {
            throw new PdcException((Throwable)((Object)e));
        }
        return objectIdList;
    }

    @Override
    public boolean hasAlreadyPositions(List<Integer> objectIdList, UsedAxis usedAxis) throws PdcException {
        String newBaseValue = "/" + usedAxis.getBaseValue() + "/";
        String instanceId = usedAxis.getInstanceId();
        boolean hasOnePosition = false;
        for (int i = 0; i < objectIdList.size() && !hasOnePosition; ++i) {
            if (objectIdList.get(i) == -1) continue;
            List<Position<Value>> positions = this.getPositions(objectIdList.get(i), instanceId);
            for (int j = 0; j < positions.size() && !hasOnePosition; ++j) {
                Value value = positions.get(j).getValueByAxis(usedAxis.getAxisId());
                String onePath = value.getValue();
                if (onePath == null || !onePath.contains(newBaseValue)) continue;
                hasOnePosition = true;
            }
        }
        return hasOnePosition;
    }

    @Override
    public List<PertinentAxis> getPertinentAxis(SearchContext searchContext, List<Integer> axisIds, List<String> instanceIds) throws PdcException {
        try {
            return this.classifyEngine.getPertinentAxisByJoin(searchContext.getCriterias(), axisIds, instanceIds);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<PertinentValue> getPertinentValues(SearchContext searchContext, int axisId, List<String> instanceIds) throws PdcException {
        try {
            return this.classifyEngine.getPertinentValuesByJoin(searchContext.getCriterias(), axisId, instanceIds);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<ObjectValuePair> getObjectValuePairs(SearchContext searchContext, int axisId, List<String> instanceIds) throws PdcException {
        try {
            return this.classifyEngine.getObjectValuePairsByJoin(searchContext.getCriterias(), axisId, instanceIds);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<Integer> findSilverContentIdByPosition(SearchContext searchContext, List<String> alComponentId, String authorId, String afterDate, String beforeDate, boolean recursiveSearch, boolean visibilitySensitive) throws PdcException {
        try {
            List<SearchCriteria> alCriterias = searchContext.getCriterias();
            return this.classifyEngine.findSilverOjectByCriterias(alCriterias, alComponentId, this.contentMgtEngine.getPositionsByGenericSearch(authorId, afterDate, beforeDate), afterDate, beforeDate, recursiveSearch, visibilitySensitive);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            ContentManagementEngine engine = ContentManagementEngineProvider.getContentManagementEngine();
            List contentIds = engine.getSilverContentIdByInstanceId(componentInstanceId);
            for (Integer contentId : contentIds) {
                this.classifyEngine.unclassifySilverObject(connection, contentId);
            }
        }
        catch (SQLException | ContentManagerException e) {
            throw new SilverpeasRuntimeException(e);
        }
        catch (ClassifyEngineException e) {
            SilverLogger.getLogger((Object)this).warn("[Deletion of {0}] {1}", new Object[]{componentInstanceId, e.getMessage()});
        }
    }
}

